package com.bxm.localnews.news.detail.helper;

import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.image.ImageHelper;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 帖子图片处理辅助类
 *
 * @author liujia
 * @date 1/14/21 2:06 PM
 **/
@Component
public class ForumPostImageHelper {

    @Resource
    private ImageHelper imageHelper;

    @Resource
    private NewsProperties newsProperties;

    /**
     * 组装首页feed流帖子展示的封面
     *
     * @param forumPostVo 帖子信息
     */
    public void exchangeCoverPost(ForumPostVo forumPostVo) {
        List<PostImgVo> coverFromPost = imageHelper.converSelect(forumPostVo.getCoverList(),
                forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
        forumPostVo.setPostImgList(coverFromPost);
        if (CollectionUtils.isNotEmpty(coverFromPost)) {
            forumPostVo.setShareImg(coverFromPost.get(0));
        } else {
            forumPostVo.setShareImg(PostImgVo.buildImg(newsProperties.getDefaultShareCover()));
        }
    }

    /**
     * 按次序取得分享图片
     *
     * @param forumPostVo 帖子信息
     * @return 图片
     */
    public PostImgVo getShareImg(ForumPostVo forumPostVo) {
        if (null == forumPostVo) {
            return PostImgVo.buildImg(newsProperties.getDefaultShareCover());
        }

        List<PostImgVo> coverFromPost = imageHelper.converSelect(forumPostVo.getCoverList(),
                forumPostVo.getPostImgList(),
                forumPostVo.getCoverSelect());
        if (CollectionUtils.isNotEmpty(coverFromPost)) {
            return coverFromPost.get(0);
        } else {
            return PostImgVo.buildImg(newsProperties.getDefaultShareCover());
        }
    }

    /**
     * 组装本地圈feed流帖子展示的封面
     *
     * @param forumPostVo 帖子详情
     */
    public void exchangeDetailPost(ForumPostVo forumPostVo) {
        forumPostVo.setShareImg(getShareImg(forumPostVo));
        forumPostVo.setPostImgList(imageHelper.getDetailFromPost(forumPostVo.getPostImgList()));
    }
}
