/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.util;

import com.bxm.localnews.news.constant.GlobalConstant;
import com.bxm.localnews.news.dto.LocationDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.util.PlaceHolderUtil;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FormPostContentUtil {
    private FormPostContentUtil() {
    }

    public static String replace(String content, LocationDTO location) {
        if (Objects.nonNull(content)) {
            if (location == null) {
                location = new LocationDTO();
            }
            return PlaceHolderUtil.replace((String)content, (String)"areaname", (String)location.getName(), (String)GlobalConstant.LOCAL_NAME);
        }
        return null;
    }

    public static void replace(ForumPostVo postVo, LocationDTO location) {
        if (Objects.nonNull(postVo)) {
            if (location == null) {
                location = new LocationDTO();
            }
            postVo.setTitle(FormPostContentUtil.replace(postVo.getTitle(), location));
            postVo.setContent(FormPostContentUtil.replace(postVo.getContent(), location));
            postVo.setTextField(FormPostContentUtil.replace(postVo.getTextField(), location));
        }
    }

    public static String getForumPostTitle(String title, String textField) {
        String forumTitle = title;
        forumTitle = StringUtils.isNotBlank((CharSequence)forumTitle) ? (forumTitle.length() > 10 ? forumTitle.substring(0, 10) + "..." : forumTitle) : (textField.length() > 10 ? textField.substring(0, 10) + "..." : textField);
        return forumTitle;
    }

    public static String getForumPostTitleTotally(String title, String textField) {
        String forumTitle = title;
        if (StringUtils.isBlank((CharSequence)forumTitle)) {
            forumTitle = textField.length() > 10 ? textField.substring(0, 10) + "..." : textField;
        }
        return forumTitle;
    }
}

