/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.detail.helper;

import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.image.ImageHelper;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ForumPostImageHelper {
    @Resource
    private ImageHelper imageHelper;
    @Resource
    private NewsProperties newsProperties;

    public void exchangeCoverPost(ForumPostVo forumPostVo) {
        List coverFromPost = this.imageHelper.converSelect(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
        forumPostVo.setPostImgList(coverFromPost);
        if (CollectionUtils.isNotEmpty((Collection)coverFromPost)) {
            forumPostVo.setShareImg((PostImgVo)coverFromPost.get(0));
        } else {
            forumPostVo.setShareImg(PostImgVo.buildImg((String)this.newsProperties.getDefaultShareCover()));
        }
    }

    public PostImgVo getShareImg(ForumPostVo forumPostVo) {
        if (null == forumPostVo) {
            return PostImgVo.buildImg((String)this.newsProperties.getDefaultShareCover());
        }
        List coverFromPost = this.imageHelper.converSelect(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect());
        if (CollectionUtils.isNotEmpty((Collection)coverFromPost)) {
            return (PostImgVo)coverFromPost.get(0);
        }
        return PostImgVo.buildImg((String)this.newsProperties.getDefaultShareCover());
    }

    public void exchangeDetailPost(ForumPostVo forumPostVo) {
        forumPostVo.setShareImg(this.getShareImg(forumPostVo));
        forumPostVo.setPostImgList(this.imageHelper.getDetailFromPost(forumPostVo.getPostImgList()));
    }
}

