package com.bxm.localnews.news.model.bo;

import com.bxm.localnews.news.model.entity.ForumPostAreaRelationEntity;
import com.bxm.localnews.news.model.entity.ForumPostContentEntity;
import com.bxm.localnews.news.model.entity.ForumPostEntity;
import com.bxm.localnews.news.model.entity.ForumPostTotalEntity;
import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

/**
 * 帖子完整详情信息聚合对象
 *
 * @author liujia
 * @date 9/12/21 10:41 PM
 **/
@Data
public class ForumPostDetailBO {

    public ForumPostDetailBO() {
        postInfo = new ForumPostEntity();
        totalInfo = new ForumPostTotalEntity();
        content = new ForumPostContentEntity();
        areaRelationList = Lists.newArrayList();
    }

    public ForumPostDetailBO(Long postId) {
        postInfo = new ForumPostEntity();
        totalInfo = new ForumPostTotalEntity();
        content = new ForumPostContentEntity();
        areaRelationList = Lists.newArrayList();

        setPostId(postId);
    }

    /**
     * 帖子地区关联信息
     */
    private List<ForumPostAreaRelationEntity> areaRelationList;

    /**
     * 帖子主体信息
     */
    private ForumPostEntity postInfo;

    /**
     * 帖子统计信息
     */
    private ForumPostTotalEntity totalInfo;

    /**
     * 帖子富文本内容信息
     */
    private ForumPostContentEntity content;

    public void setPostId(Long postId) {
        postInfo.setId(postId);
        totalInfo.setPostId(postId);
        content.setPostId(postId);

        for (ForumPostAreaRelationEntity entity : areaRelationList) {
            entity.setPostId(postId);
        }
    }

    public void addRelation(ForumPostAreaRelationEntity entity) {
        if (null == areaRelationList) {
            areaRelationList = Lists.newArrayList();
        }

        areaRelationList.add(entity);
    }

    public ForumPostAreaRelationEntity getFirstRelation() {
        if (null == areaRelationList || areaRelationList.size() == 0) {
            return null;
        }

        return areaRelationList.get(0);
    }
}
