package com.bxm.localnews.news.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("帖子发布返回实体")
@Data
public class ForumPostCreateDTO {

    @ApiModelProperty("新闻分享跳转地址")
    private String shareUrl;

    @ApiModelProperty("帖子返回实体")
    private ForumPost forumPost;

    @ApiModelProperty("1.2.0 用户支付完成后，支付引导跳转到开仓放粮的支付页面")
    private Boolean guidePayment;

    @Data
    public static class ForumPost {

        @ApiModelProperty("帖子id")
        private Long id;

        @ApiModelProperty("帖子图片以及视频列表")
        private String postImgUrl;

        @ApiModelProperty("帖子文本")
        private String textField;

        @ApiModelProperty("帖子标题")
        private String title;

    }
}
