package com.bxm.localnews.news.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

@ApiModel(description = "分享内容对象")
@Data
@Builder
public class ShareContentDTO {
    @Tolerate
    public ShareContentDTO() {
    }

    @ApiModelProperty("内容ID，根据origin使用不同的分享地址")
    private Long id;

    @ApiModelProperty("内容来源，1：社区帖子")
    private String origin;

    @ApiModelProperty("内容标题")
    private String title;

    @ApiModelProperty("内容分享次数")
    private Integer shareNum;

    @ApiModelProperty("内容阅读次数")
    private Integer readNum;

    @ApiModelProperty(value = "分享图的地址", hidden = true)
    private String shareImgUrl;

    @ApiModelProperty("内容图片地址列表")
    private List<String> imgList;
}
