package com.bxm.localnews.news.model.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;
import java.util.List;

@Builder
@Data
@ApiModel(description = "投票插件详情")
public class VoteDetailDTO {

    @Tolerate
    public VoteDetailDTO() {
    }

    @ApiModelProperty("投票插件ID")
    private Long voteId;

    @ApiModelProperty("投票插件名称")
    private String name;

    @ApiModelProperty("投票选项类型，RADIO：单选，CHECKBOX：多选")
    private String optionType;

    @ApiModelProperty("投票按钮状态,ENABLE:可点击，DISABLE：不可点击")
    private String status;

    @ApiModelProperty("投票按钮触发动作，VOTE:投票，SHARE：引导分享")
    private String action;

    @ApiModelProperty("投票对应显示文案，为空时不显示。eg：你已投票、投票活动已结束")
    private String statusLabel;

    @ApiModelProperty("投票状态副标题，如果为null则不显示,eg:今日还可再投N次")
    private String subTitle;

    @ApiModelProperty("布局方案，TEXT：竖排纯文字布局，IMG：两列的图片布局")
    private String layoutType;

    @ApiModelProperty("投票选项信息")
    private List<VoteOptionDTO> options;

    @ApiModelProperty(value = "投票限制（策略），DAY:每日上限，MAX：总数上限", hidden = true)
    private String voteStrategy;

    @ApiModelProperty("投票截止时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty(value = "投票是否已过期", hidden = true)
    private Boolean expired;

    @ApiModelProperty(value = "最多投票次数，根据投票策略不同，定义不同", hidden = true)
    private Integer max;
}
