package com.bxm.localnews.news.model.dto.activity;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author liujia
 * @date 1/12/21 8:18 PM
 **/
@ApiModel(description = "活动帖子信息")
@Data
public class ActivityPostItemDTO {
    @ApiModelProperty("帖子ID")
    private Long id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("发帖区域")
    private String areaDetail;

    @ApiModelProperty("发布区域类型 0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("作者名称")
    private String userName;

    @ApiModelProperty("活动所属商户ID")
    private Long merchantId;

    @ApiModelProperty("活动所属商户名称")
    private String merchantName;

    @ApiModelProperty("热文状态，0：未开始，1：生效中")
    private Integer shareCashStatus;

    @ApiModelProperty("奖励有效期-开始时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date awardStartTime;

    @ApiModelProperty("奖励有效期-截止时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date awardEndTime;

    @ApiModelProperty("发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date publishTime;

    @ApiModelProperty("所属话题")
    private String topicName;

    @ApiModelProperty("所属话题ID")
    private Long topicId;

    @ApiModelProperty("帖子状态(1:正常显示 2:审核中 3:审核拒绝 4:用户删除 5:仅楼主可见 6:本地圈屏蔽 7:运营删除)")
    private Byte status;

    @ApiModelProperty("帖子预览链接")
    private String linkUrl;

    @ApiModelProperty("3.11.0 是否分享奖励现金：0否 1是")
    private Integer isShareCash;

    @ApiModelProperty("是否推荐（是否优质头条）：0否 1是")
    private Byte isRecommend;
}
