package com.bxm.localnews.news.model.dto.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * @author liujia
 * @date 1/12/21 7:32 PM
 **/
@ApiModel(description = "活动帖子的额外扩展字段")
@Data
@Builder
public class PostActivityExtendDTO {

    @Tolerate
    public PostActivityExtendDTO() {
    }

    @ApiModelProperty("活动状态，0：未开始，1：进行中，2：已结束")
    private Integer activityStatus;

    @ApiModelProperty("参与活动按钮上的文案")
    private String joinText;

    @ApiModelProperty("点击按钮后的跳转地址，站内为协议地址，站外为H5地址")
    private String protocolUrl;
}
