package com.bxm.localnews.news.model.dto.hotpost;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liujia
 * @date 1/12/21 8:50 PM
 **/
@Data
@ApiModel(description = "热文贴信息")
public class ShareCashPostItemDTO {
    @ApiModelProperty("帖子ID")
    private Long id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("发帖区域")
    private String areaDetail;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("作者名称")
    private String userName;

    @ApiModelProperty("奖励有效期-开始时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date awardStartTime;

    @ApiModelProperty("奖励有效期-截止时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date awardEndTime;

    @ApiModelProperty("发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date publishTime;

    @ApiModelProperty("帖子状态(1:正常显示 2:审核中 3:审核拒绝 4:用户删除 5:仅楼主可见 6:本地圈屏蔽 7:运营删除)")
    private Byte status;

    @ApiModelProperty("帖子权重")
    private Integer order;

    @ApiModelProperty("帖子类型，活动贴、社区帖")
    private String postType;

    @ApiModelProperty("已发放奖励金额")
    private BigDecimal usedAmount;

    @ApiModelProperty("发布区域类型 0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("详情预览跳转地址")
    private String linkUrl;
}
