package com.bxm.localnews.news.model.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bxm.localnews.news.vo.PostImgVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 帖子富文本相关信息
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_forum_post_content")
@ApiModel(value = "ForumPostContentEntity对象", description = "帖子富文本相关信息")
public class ForumPostContentEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "帖子ID")
    @TableId("post_id")
    private Long postId;

    @ApiModelProperty(value = "帖子文本部分")
    private String textField;

    @ApiModelProperty(value = "帖子内容（最终显示文本，HTML）")
    private String content;

    @ApiModelProperty(value = "帖子图片（json字符串）")
    private String imgList;

    @ApiModelProperty(value = "帖子图片（对象格式，不入库）")
    @TableField(exist = false)
    private List<PostImgVo> imgInfoList;

    @ApiModelProperty(value = "封面图片列表")
    private String coverList;

    @ApiModelProperty(value = "点赞概览信息")
    private String likeInfo;

    @ApiModelProperty(value = "帖子使用的插件列表（JSON结构）")
    private String plugins;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;


}
