package com.bxm.localnews.news.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 帖子信息表
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_forum_post")
@ApiModel(value = "ForumPostEntity对象", description = "帖子信息表")
public class ForumPostEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "发帖用户ID")
    private Long userId;

    @ApiModelProperty(value = "创建人（仅针对运营录入）")
    private Long creator;

    @ApiModelProperty(value = "帖子标题")
    private String title;

    @ApiModelProperty(value = "帖子简略内容，从内容中进行提取")
    private String brief;

    @ApiModelProperty(value = "发帖时的用户位置（默认取所属区域名称）")
    private String location;

    @ApiModelProperty(value = "是否精华帖(显示精华帖的章)")
    private Integer isBrilliant;

    @ApiModelProperty(value = "是否推荐")
    private Integer isRecommend;

    @ApiModelProperty(value = "是否本地爆料")
    private Integer isBroke;

    @ApiModelProperty(value = "是否发放了现金奖励")
    private Integer isCash;

    @ApiModelProperty(value = "是否红色章（只对精华帖有效）")
    private Integer isRed;

    @ApiModelProperty(value = "是否分享奖励现金,0否，1是")
    private Integer isShareCash;

    @ApiModelProperty(value = "用户是否首次发帖 0：否 1：是")
    private Integer isFirstUserPost;

    @ApiModelProperty(value = "是否强引导下载  0:否 1:是")
    private Integer isBootDownload;

    @ApiModelProperty(value = "是否是活动帖子0否，1是")
    private Integer isActivityPost;

    @ApiModelProperty(value = "是否用户修改,0否,1是")
    private Integer isUserUpdate;

    @ApiModelProperty(value = "是否启用占位符")
    private Integer enablePlaceholder;

    @ApiModelProperty(value = "现金奖励金额")
    private BigDecimal cashReward;

    @ApiModelProperty(value = "展示标签：1热 2爆")
    private Integer displayTag;

    @ApiModelProperty(value = "自定义标签内容")
    private String labelDiv;

    @ApiModelProperty(value = "帖子类型(1:普通帖子 2:小纸条)")
    private Integer postType;

    @ApiModelProperty(value = "小纸条的有效期(单位:天)")
    private Integer validDay;

    @ApiModelProperty(value = "选择的话题列表ID")
    private String topicIds;

    @ApiModelProperty(value = "帖子状态(1:正常显示 2:审核中 3:审核拒绝 4:用户删除 5:仅楼主可见 6:本地圈屏蔽 7:运营删除)")
    private Integer status;

    @ApiModelProperty(value = "编辑寄语id")
    private Long editorMessageId;

    @ApiModelProperty(value = "封面选择 0:只取图片 1:只取第一个视频  2:取内容详情的视频和图片")
    private Integer coverSelect;

    @ApiModelProperty(value = "付费推广状态，0：未推广，1：推广中，2：推广结束")
    private Integer promotionStatus;

    @ApiModelProperty(value = "每次阅读获得的粮食数据")
    private Integer grantNum;

    @ApiModelProperty(value = "获取粮食的有效阅读倒计时事件（秒）")
    private Integer grantCountDown;

    @ApiModelProperty(value = "帖子热度值")
    private Integer hotScore;

    @ApiModelProperty(value = "帖子分享用户的图片")
    private String shareImg;

    @ApiModelProperty(value = "帖子包含的图片和视频的数量")
    private Integer imgSize;

    @ApiModelProperty(value = "到期时间")
    private Date validDate;

    @ApiModelProperty(value = "发布时间（用于运营定时发布）")
    private Date publishTime;

    @ApiModelProperty(value = "发布时间（用于客户端显示）")
    private Date displayTime;

    @ApiModelProperty(value = "创建时间（真实的创建时间）")
    private Date createTime;

    @ApiModelProperty(value = "数据变更时间")
    private Date modifyTime;


}
