package com.bxm.localnews.news.model.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 帖子统计信息表
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_forum_post_total")
@ApiModel(value = "ForumPostTotalEntity对象", description = "帖子统计信息表")
@Builder
public class ForumPostTotalEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @Tolerate
    public ForumPostTotalEntity() {
    }

    @ApiModelProperty(value = "帖子ID")
    @TableId("post_id")
    private Long postId;

    @ApiModelProperty(value = "阅读(点击)总数-用户真实看到的数量")
    private Long clickCount;

    @ApiModelProperty(value = "该帖子最终需要达到的用户阅读数量（由真实阅读数量计算而来）")
    private Long finalClickCount;

    @ApiModelProperty(value = "有效阅读总数（3.8.0定义为真实阅读数量）")
    private Long reviewCount;

    @ApiModelProperty(value = "初始基数")
    private Long initialBasicNum;

    @ApiModelProperty(value = "评论总数")
    private Long commentCount;

    @ApiModelProperty(value = "分享总数")
    private Integer shareCount;

    @ApiModelProperty(value = "真实分享总数")
    private Integer realShareCount;

    @ApiModelProperty(value = "热文奖励帖子的基础随机分享数")
    private Integer baseShareCount;

    @ApiModelProperty(value = "推荐总次数")
    private Long recommendCount;

    @ApiModelProperty(value = "收藏总数")
    private Long collectCount;

    @ApiModelProperty(value = "点赞总数")
    private Long likeCount;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    public boolean hasNewValue() {
        return clickCount != null ||
                finalClickCount != null ||
                reviewCount != null ||
                initialBasicNum != null ||
                commentCount != null ||
                shareCount != null ||
                realShareCount != null ||
                baseShareCount != null ||
                recommendCount != null ||
                collectCount != null ||
                likeCount != null;
    }
}
