package com.bxm.localnews.news.model.entity.activity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 开仓放粮活动记录
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_activity_grain")
@ApiModel(value = "ActivityGrainEntity对象", description = "开仓放粮活动记录")
public class ActivityGrainEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "发起的用户")
    private Long userId;

    @ApiModelProperty(value = "对应的帖子ID")
    private Long postId;

    @ApiModelProperty(value = "支付订单编号")
    private String orderNo;

    @ApiModelProperty(value = "用户实际支付的金额")
    private BigDecimal money;

    @ApiModelProperty(value = "每次有效阅读的奖励粮食")
    private Integer grantNum;

    @ApiModelProperty(value = "投放人数")
    private Integer num;

    @ApiModelProperty(value = "投放粮食总数")
    private Integer total;

    @ApiModelProperty(value = "有效阅读的倒计时")
    private Integer countDown;

    @ApiModelProperty(value = "当前状态")
    private Integer status;

    @ApiModelProperty(value = "投放区域，0表示全部投放")
    private String areaCode;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "推广结束时间")
    private Date finishTime;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "变更时间")
    private Date modifyTime;


}
