package com.bxm.localnews.news.model.entity.activity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 粮食领取记录
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_activity_grain_record")
@ApiModel(value = "ActivityGrainRecordEntity对象", description = "粮食领取记录")
public class ActivityGrainRecordEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "领取的帖子ID")
    private Long postId;

    @ApiModelProperty(value = "领取粮食的用户ID")
    private Long userId;

    @ApiModelProperty(value = "领取数量")
    private Integer num;

    @ApiModelProperty(value = "领取时间")
    private Date createTime;


}
