package com.bxm.localnews.news.model.entity.activity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 开仓放粮统计数据
 * </p>
 *
 * @author liujia
 * @since 2021-09-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_activity_grain_total")
@ApiModel(value = "ActivityGrainTotalEntity对象", description = "开仓放粮统计数据")
@Builder
public class ActivityGrainTotalEntity implements Serializable {

    @Tolerate
    public ActivityGrainTotalEntity() {
    }

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "开仓放粮活动记录ID")
    private Long grainId;

    @ApiModelProperty(value = "所属帖子ID")
    private Long postId;

    @ApiModelProperty(value = "粮食总数")
    private Integer total;

    @ApiModelProperty(value = "已被领取的粮食总数")
    private Integer receivedNum;

    @ApiModelProperty(value = "曝光次数")
    private Integer visibleNum;

    @ApiModelProperty(value = "有效阅读次数")
    private Integer readNum;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;


}
