package com.bxm.localnews.news.model.entity.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * t_forum_post_activity
 *
 * @author
 */
@Data
public class ForumPostActivityEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 帖子ID
     */
    private Long postId;

    /**
     * 帖子活动所属商家
     */
    private Long merchantId;

    /**
     * 商家名称
     */
    private String merchantName;

    /**
     * 活动的商品ID
     */
    private Long goodsId;

    /**
     * 活动状态（0: 活动下架、1：活动上架）
     */
    private Integer status;

    /**
     * 参与活动的引导文案
     */
    private String joinText;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    /**
     * 创建人（运营ID）
     */
    private Long creator;

    /**
     * 活动贴类型，1：商品活动，2：其他
     */
    private Integer activityType;

    /**
     * 跳转协议地址
     */
    private String protocol;

    private static final long serialVersionUID = 1L;
}