package com.bxm.localnews.news.model.entity.activity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * t_forum_post_share_cash_info
 *
 * @author
 */
@Data
public class ForumPostShareCashInfoEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 帖子ID
     */
    private Long postId;

    /**
     * 奖励开始时间
     */
    private Date awardStartTime;

    /**
     * 奖励结束时间
     */
    private Date awardEndTime;

    /**
     * 奖励总金额
     */
    private BigDecimal amount;

    /**
     * 已发放金额
     */
    private BigDecimal usedAmount;

    /**
     * 分享奖励贴的状态（0：过期，1：生效）
     */
    private Integer status;

    /**
     * 创建人
     */
    private Long creator;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    /**
     * 显示顺序
     */
    private Integer order;

    /**
     * 每次阅读的奖励金额（默认：0.01）
     */
    private BigDecimal award;

    private static final long serialVersionUID = 1L;
}