package com.bxm.localnews.news.model.entity.activity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * t_forum_post_share_cash_record
 *
 * @author
 */
@Data
public class ForumPostShareCashRecordEntity implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 浏览人唯一标识，这里存的是openid
     */
    private String token;

    /**
     * 浏览帖子ID
     */
    private Long postId;

    /**
     * 奖励金额
     */
    private BigDecimal award;

    /**
     * 奖励所属用户
     */
    private Long userId;

    /**
     * 奖励发放状态（0：未发放、1：已发放、2：作弊废弃）
     */
    private Integer status;

    /**
     * 阅读IP
     */
    private String ip;

    /**
     * 请求UA
     */
    private String userAgent;

    /**
     * 记录时间
     */
    private Date createTime;

    private static final long serialVersionUID = 1L;
}