package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@ApiModel("帖子参数实体")
@Data
@Builder
public class AdminForumPostParam extends PageParam {

    @Tolerate
    public AdminForumPostParam() {

    }

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("审核状态：0拒绝 1通过 2待审核")
    private Integer status;

    @ApiModelProperty("是否精华帖：0否 1是")
    private Integer isBrilliant;

    @ApiModelProperty("是否推荐：0否 1是")
    private Integer isRecommend;

    @ApiModelProperty("展示标签：1热 2爆 3自定义")
    private Integer displayTag;

    @ApiModelProperty("自定义标签内容")
    private String labelDiv;

    @ApiModelProperty("所属版块id")
    private Long forumId;

    @ApiModelProperty("所属话题id")
    private Long topicId;

    @ApiModelProperty("发帖人id")
    private Long userId;

    @ApiModelProperty("帖子id")
    private Long id;

    @ApiModelProperty("帖子内容")
    private String content;

    @ApiModelProperty("定时发布时间开始时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date publishStartTime;

    @ApiModelProperty("定时发布时间结束时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date publishEndTime;

    @ApiModelProperty("是否0评论：0否 1是")
    private Integer isZeroReply;

    @ApiModelProperty("帖子类型(1:普通帖子 2:小纸条)")
    private Integer postType;

    @ApiModelProperty("是否运营发帖 0真实用户,1马甲号")
    private Byte isOperate;

    @ApiModelProperty("是否奖励现金：0否 1是")
    private Byte isCash;

    @ApiModelProperty("3.11.0分享得现金的热文状态，1：全部热文，2：热文生效中，3：热文已失效")
    private Integer shareCashStatus;
}
