package com.bxm.localnews.news.model.param;

import com.bxm.egg.common.vo.IUserIdSharding;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lowi
 * @date 2020/12/16 13:54
 */
@ApiModel("收益保存或更新类")
@Data
public class EarningsSaveOrUpdateParam implements IUserIdSharding {
    @ApiModelProperty(value = "用户id", hidden = true)
    private Long userId;

    @ApiModelProperty("收益类型")
    private Integer earningsType;

    @ApiModelProperty("收益标题")
    private String earningsTitle;

    @ApiModelProperty("收益类型不同，代表不同类型的id")
    private Long relationId;

    @ApiModelProperty("收益的图片")
    private String img;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("订单时间")
    private Date orderTime;

    @ApiModelProperty(value = "佣金", hidden = true)
    private BigDecimal commission;

    @ApiModelProperty(value = "状态   1 待核销 2 已结算 3 待升级 4 已失效", hidden = true)
    private Integer status;

    @ApiModelProperty(value = "是否是团队收益 0 不是 1是", hidden = true)
    private Integer isTeamEarnings;

    @ApiModelProperty("购买的用户id")
    private Long sellUserId;
}
