package com.bxm.localnews.news.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 视频举报传参
 *
 * @author
 */
@ApiModel(description = "帖子举报传参")
public class ForumPostInformParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("举报帖子id")
    private Long postId;

    @ApiModelProperty("举报的回复id")
    private Long replyId;

    @ApiModelProperty("举报类型（1.举报帖子  2.举报评论）")
    private Byte informType;

    @ApiModelProperty("举报人")
    private Long userId;

    @ApiModelProperty("举报内容")
    private String remark;

    @ApiModelProperty("举报标签(与新闻一样)")
    private String label;

    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }

    public Long getReplyId() {
        return replyId;
    }

    public void setReplyId(Long replyId) {
        this.replyId = replyId;
    }

    public Byte getInformType() {
        return informType;
    }

    public void setInformType(Byte informType) {
        this.informType = informType;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}