package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.param.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "帖子列表查询")
public class ForumPostListQueryParam extends BasicParam {

    @ApiModelProperty("当前用户id")
    @NotNull
    private Long userId;

    @ApiModelProperty("查看的用户ID，查看他人主页时，传递查看目标用户的ID")
    private Long targetUserId;

    @ApiModelProperty("主题id")
    private Long topicId;

    @ApiModelProperty("类型：0热门 1精选 2最新 3社区首页")
    @NotNull
    private Integer type;

    @ApiModelProperty("推荐方式，1：下拉刷新，2：上拉刷新，首次进入为下拉刷新")
    private Integer recommendType;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("主题id集合：3.3.1新增")
    private String channelIds;

    @ApiModelProperty("分页查询参数，当前是第几页,min[1]")
    private Integer pageNum = 1;

    @ApiModelProperty("分页查询参数，每页显示数量,默认为10,rang[1,200]")
    private Integer pageSize = 10;

}
