package com.bxm.localnews.news.model.param;

import com.bxm.egg.common.param.BaseUserParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author liujia
 * @date 9/12/21 4:15 PM
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "付费推广信息保存参数")
public class GrainPromotionParam extends BaseUserParam {

    @ApiModelProperty("推广目标区域，0表示全国。将强制定义帖子的对应地区。")
    private String targetAreaCode;

    @ApiModelProperty("推广的帖子ID")
    @NotNull(message = "推广的帖子ID不能为空")
    private Long postId;

    @ApiModelProperty("每次有效阅读给的粮食数量")
    @NotNull(message = "有效阅读发放的粮食数量不能为空")
    private Integer grantNum;

    @ApiModelProperty("预计投放总人次")
    @NotNull(message = "预计投放总人次不能为空")
    private Integer totalNum;

    @ApiModelProperty("预计支付金额，服务端进行二次校验")
    private BigDecimal price;
}
