package com.bxm.localnews.news.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import javax.validation.constraints.NotNull;

@ApiModel("屏蔽文章参数实体")
@Builder
@Data
public class NewsShieldParam {

    @ApiModelProperty(value = "屏蔽的文章id[必传]", required = true)
    private Long shieldNewsId;

    @ApiModelProperty(value = "屏蔽的用户id，也就是文章的用户id[必传]", required = true)
    private Long shieldUserId;

    @NotNull
    @ApiModelProperty(value = "当前用户id", required = true)
    private Long userId;

    @NotNull
    @ApiModelProperty(value = "屏蔽类型 1.屏蔽此条 2.屏蔽该作者 3.投诉广告 4.内容涉嫌违法 , 其中3和4不需要折叠内容！", required = true)
    private Byte shieldType;

    @NotNull
    @ApiModelProperty(value = "类型1.新闻 2.小视频 3.帖子", required = true)
    private Byte type;

    @Tolerate
    public NewsShieldParam() {
    }
}
