package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.param.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * @author gonzo
 * @date 2020-11-25 15:47
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "发特殊帖子的参数")
public class PostSpecialForumParam extends BasicParam {

    @ApiModelProperty(value = "类型 1: 新人报道帖子", required = true)
    @NotNull(message = "类型不能为空")
    private Integer type;

    @ApiModelProperty(value = "用户id", required = true)
    @NotNull(message = "用户id不能为空")
    private Long userId;

    @ApiModelProperty(value = "区域编码", required = true)
    private String areaCode;
}
