package com.bxm.localnews.news.model.param.hotpost;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/12 9:07 下午
 */
@Data
@ApiModel("查询热文列表分页入参")
public class HotPostListPageParam extends PageParam {
    private static final long serialVersionUID = -4541921485355192284L;
    @ApiModelProperty(value = "用户id", required = true)
    @NotNull(message = "用户id不能为空")
    private Long userId;

    @ApiModelProperty(value = "区域编码", required = true)
    @NotNull(message = "地区编码不能为空")
    private String areaCode;

    @ApiModelProperty(value = "获取热文类型：1获取我发布的热文，2获取热文分享")
    @NotNull(message = "热文类型不能为空")
    private Integer type;
}