package com.bxm.localnews.news.model.param.hotpost;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author liujia
 * @date 1/12/21 9:00 PM
 **/
@Data
@ApiModel(description = "变更热文贴的奖励时间")
public class ShareCashPostAwardParam {
    @ApiModelProperty("帖子ID")
    private Long id;

    @ApiModelProperty("奖励有效期-开始时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date awardStartTime;

    @ApiModelProperty("奖励有效期-截止时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date awardEndTime;
}
