package com.bxm.localnews.news.model.param.hotpost;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author liujia
 * @date 1/12/21 8:25 PM
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "分页获取热文帖子参数")
@Data
public class ShareCashPostPageParam extends PageParam {

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("帖子id")
    private Long id;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("定时发布时间开始时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date publishStartTime;

    @ApiModelProperty("定时发布时间结束时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date publishEndTime;

    @ApiModelProperty("帖子类型，1：活动帖子，2：社区帖子")
    private Integer postType;

    @ApiModelProperty("分享得现金的热文状态，1：全部热文，2：热文生效中，3：热文已失效")
    private Integer shareCashStatus;
}
