package com.bxm.localnews.news.model.vo;

import com.bxm.localnews.news.model.vo.topic.AdminTopic;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel(description = "帖子基础详情")
@Data
public class AdminBaseForumPost {

    @ApiModelProperty("帖子id")
    private Long id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("发帖地址")
    private String location;

    @ApiModelProperty("发帖区域编码")
    private String areaCode;

    @ApiModelProperty("帖子内容")
    private String content;

    @ApiModelProperty("帖子文本")
    private String textField;

    @ApiModelProperty("帖子图片")
    private String imgList;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("作者头像")
    private String userImg;

    @ApiModelProperty("作者名称")
    private String userName;

    @ApiModelProperty("用户昵称")
    private String nickName;

    @ApiModelProperty("是否精华帖：0否 1是")
    private Byte isBrilliant;

    @ApiModelProperty("是否推荐（是否优质头条）：0否 1是")
    private Byte isRecommend;

    @ApiModelProperty("是否红色章：0否 1是")
    private Byte isRed;

    @ApiModelProperty("是否奖励现金：0否 1是")
    private Byte isCash;

    @ApiModelProperty("现金奖励金额")
    private BigDecimal cashReward;

    @ApiModelProperty("是否本地爆料：0否 1是")
    private Byte isBroke;

    @ApiModelProperty("展示标签：1热 2爆 3 自定义")
    private Byte displayTag;

    @ApiModelProperty("标签自定义内容")
    private String labelDiv;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("定时发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date publishTime;

    @ApiModelProperty("展示时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date displayTime;

    @ApiModelProperty("帖子状态(1:正常显示 2:审核中 3:审核拒绝 4:用户删除 5:仅楼主可见 6:本地圈屏蔽 7:运营删除)")
    private Integer status;

    @ApiModelProperty(value = "帖子使用的插件列表（JSON结构）", hidden = true)
    private String plugins;

    @ApiModelProperty("发布区域类型 0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("帖子类型(1:普通帖子 2:小纸条)")
    private Byte postType;

    @ApiModelProperty("用户状态： 0-游客 1-可使用 2-未激活 3-虚拟 9-禁用")
    private Integer userState;

    @ApiModelProperty("发帖区域")
    private String areaDetail;

    @ApiModelProperty("话题id列表")
    private List<Long> topicIdList;

    @ApiModelProperty("话题列表")
    private List<AdminTopic> topicList;

    @ApiModelProperty("更新时间")
    private Date modifyTime;

    @ApiModelProperty("发帖人身份 0:马甲号 1:真实用户")
    private Byte identity;

    @ApiModelProperty("帖子详情跳转地址")
    private String linkUrl;

    @ApiModelProperty("投票插件ID")
    private String votePluginId;

    @ApiModelProperty("是否过期 true:未过期 false:过期")
    private Boolean isValid;

    @ApiModelProperty("短连接")
    private String shortUrl;

    @ApiModelProperty("站内链接")
    private String appUrl;

    @ApiModelProperty("H5分享链接")
    private String webUrl;

    @ApiModelProperty("是否是未到发布时间的预发布帖子，1: 是")
    private Integer isPrePublish;

    @ApiModelProperty(value = "参与的话题ID，用逗号分隔", hidden = true)
    private String topicIds;

    @ApiModelProperty(value = "热文贴子基础阅读数")
    private Integer baseShareCount;
}
