package com.bxm.localnews.news.model.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "帖子基础详情")
@Data
public class AdminBaseForumPostExcelVO extends BaseBean {

    @ApiModelProperty("帖子id")
    private String id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("发帖地址")
    private String location;

    @ApiModelProperty("发帖区域编码")
    private String areaCode;

    @ApiModelProperty("帖子内容")
    private String content;

    @ApiModelProperty("帖子文本")
    private String textField;

    @ApiModelProperty("帖子图片")
    private String imgList;

    @ApiModelProperty("作者id")
    private String userId;

    @ApiModelProperty("作者头像")
    private String userImg;

    @ApiModelProperty("作者名称")
    private String userName;

    @ApiModelProperty("是否精华帖：0否 1是")
    private String isBrilliant;

    @ApiModelProperty("是否推荐（是否优质头条）：0否 1是")
    private String isRecommend;

    @ApiModelProperty("是否红色章：0否 1是")
    private String isRed;

    @ApiModelProperty("是否奖励现金：0否 1是")
    private String isCash;

    @ApiModelProperty("现金奖励金额")
    private String cashReward;

    @ApiModelProperty("是否本地爆料：0否 1是")
    private String isBroke;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("定时发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private String publishTime;

    @ApiModelProperty("展示时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private String displayTime;

    @ApiModelProperty("帖子状态(1:正常显示 2:审核中 3:审核拒绝 4:用户删除 5:仅楼主可见 6:本地圈屏蔽 7:运营删除)")
    private String status;

    @ApiModelProperty("发布区域类型 0全国 1地方")
    private String deliveryType;

    @ApiModelProperty("帖子类型(1:普通帖子 2:小纸条)")
    private String postType;

    @ApiModelProperty("有效期(单位:天)")
    private Integer validDay;

    @ApiModelProperty("到期时间")
    private String validDate;

    @ApiModelProperty("用户状态： 0-游客 1-可使用 2-未激活 3-虚拟 9-禁用")
    private Integer userState;

    @ApiModelProperty("发帖区域")
    private String areaDetail;

    @ApiModelProperty("话题id列表")
    private String topicIdList;

    @ApiModelProperty("更新时间")
    private String modifyTime;

    @ApiModelProperty("发帖人身份 0:马甲号 1:真实用户")
    private String identity;

    @ApiModelProperty("帖子详情跳转地址")
    private String linkUrl;

    @ApiModelProperty("投票插件ID")
    private String votePluginId;

    @ApiModelProperty("是否过期 true:未过期 false:过期")
    private String isValid;

    @ApiModelProperty("短连接")
    private String shortUrl;

    @ApiModelProperty("站内链接")
    private String appUrl;

    @ApiModelProperty("H5分享链接")
    private String webUrl;
}
