package com.bxm.localnews.news.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@ApiModel(description = "帖子详情")
@Data
@EqualsAndHashCode(callSuper = true)
public class AdminForumPost extends AdminBaseForumPost {

    @ApiModelProperty("马甲号用户信息，格式如：方仙女(女  单身，广德)")
    private String userInfo;

    @ApiModelProperty(value = "创建人id，运营人员添加时才有值")
    private Long creator;

    @ApiModelProperty("是否强引导下载  0:否 1:是")
    private Byte isBootDownload;

    @ApiModelProperty("编辑寄语id")
    private Long editorMessageId;

    @ApiModelProperty("编辑寄语名称")
    private String editorMessageName;

    @ApiModelProperty(value = "编辑寄语", hidden = true)
    private String editorMessage;

    @ApiModelProperty("启用占位符")
    private Byte enablePlaceholder;

    @ApiModelProperty(value = "封面图片,如：" +
            "[\"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"," +
            " \"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"]")
    private String coverList;

    @ApiModelProperty(value = "视频图片,如：" +
            "[\"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"," +
            " \"xxxxxxxxxx.jpg?x-oss-process=style/thumbnail\"]")
    private String videoPosterList;

    @ApiModelProperty("是否用户首次发帖")
    private Byte isFirstUserPost = 0;

    @ApiModelProperty("封面选择 0:只取图片 ,1:只取第一个视频 ,2:取内容详情的视频和图片 ")
    private Byte coverSelect;

    @ApiModelProperty("版块内容")
    private String forumContent;

    @ApiModelProperty("评论总数")
    private Integer commentCount;

    @ApiModelProperty("评论概览")
    private String replyInfo;

    @ApiModelProperty("是否用户更新 0不是, 1用户更新")
    private Byte isUserUpdate;

    @ApiModelProperty("有效阅读总数（3.8.0定义为真实阅读数量）")
    private Long reviewCount;

    @ApiModelProperty("初始基数")
    private Long initialBasicNum;

    @ApiModelProperty("该帖子最终需要达到的用户阅读数量（由真实阅读数量计算而来）")
    private Long finalClickCount;

    @ApiModelProperty("真实的分享数")
    private Integer realShareCount;

    @ApiModelProperty("热文奖励帖子的基础随机分享数")
    private Integer baseShareCount;

    @ApiModelProperty("虚拟分享数")
    private Integer shareCount;
}
