package com.bxm.localnews.news.model.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author liujia
 */
@ApiModel(description = "帖子审核历史")
@Data
public class AdminForumPostApproveHistory {

    @ApiModelProperty(hidden = true, value = "历史记录ID")
    private Long id;

    @ApiModelProperty(hidden = true, value = "审核状态")
    private Integer status;

    @ApiModelProperty(hidden = true, value = "审核操作人")
    private Long creator;

    @ApiModelProperty("帖子id")
    private Long postId;

    @ApiModelProperty("审批动作：0拒绝，1通过")
    private Integer action;

    @ApiModelProperty("审批意见")
    private String comment;

    @ApiModelProperty("审批时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date createTime;
}
