package com.bxm.localnews.news.model.vo;

import java.io.Serializable;

/**
 * t__post
 *
 * @author
 */
public class ForumPostStatistic implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 阅读(点击)总数
     */
    private Integer clickCount;

    /**
     * 有效阅读总数
     */
    private Integer reviewCount;

    /**
     * 评论总数
     */
    private Integer commentCount;

    /**
     * 分享总数（对于热文来说是虚拟分享数）
     */
    private Integer shareCount;

    /**
     * 真实分享数
     */
    private Integer realShareCount;

    /**
     * 收藏总数
     */
    private Integer collectCount;

    /**
     * 推荐总次数
     */
    private Integer recommendCount;

    /**
     * 点赞总数
     */
    private Integer likeCount;

    /**
     * 点赞概览信息
     */
    private String likeInfo;

    /**
     * 评论概览信息
     */
    private String replyInfo;

    /**
     * 该帖子最终需要达到的用户阅读数量（由真实阅读数量计算而来）
     */
    private Long finalClickCount;

    /**
     * 初始基数
     */
    private Long initialBasicNum;

    public Long getInitialBasicNum() {
        return initialBasicNum;
    }

    public void setInitialBasicNum(Long initialBasicNum) {
        this.initialBasicNum = initialBasicNum;
    }

    public Long getFinalClickCount() {
        return finalClickCount;
    }

    public void setFinalClickCount(Long finalClickCount) {
        this.finalClickCount = finalClickCount;
    }

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getClickCount() {
        return clickCount;
    }

    public void setClickCount(Integer clickCount) {
        this.clickCount = clickCount;
    }

    public Integer getReviewCount() {
        return reviewCount;
    }

    public void setReviewCount(Integer reviewCount) {
        this.reviewCount = reviewCount;
    }

    public Integer getCommentCount() {
        return commentCount;
    }

    public void setCommentCount(Integer commentCount) {
        this.commentCount = commentCount;
    }

    public Integer getShareCount() {
        return shareCount;
    }

    public void setShareCount(Integer shareCount) {
        this.shareCount = shareCount;
    }

    public Integer getCollectCount() {
        return collectCount;
    }

    public void setCollectCount(Integer collectCount) {
        this.collectCount = collectCount;
    }

    public Integer getRecommendCount() {
        return recommendCount;
    }

    public void setRecommendCount(Integer recommendCount) {
        this.recommendCount = recommendCount;
    }

    public Integer getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public String getLikeInfo() {
        return likeInfo;
    }

    public void setLikeInfo(String likeInfo) {
        this.likeInfo = likeInfo;
    }

    public String getReplyInfo() {
        return replyInfo;
    }

    public void setReplyInfo(String replyInfo) {
        this.replyInfo = replyInfo;
    }

    public Integer getRealShareCount() {
        return realShareCount;
    }

    public void setRealShareCount(Integer realShareCount) {
        this.realShareCount = realShareCount;
    }

    public static ForumPostStatistic buildRecommend(Long id, Integer recommendCount) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setRecommendCount(recommendCount);
        forumPostStatistic.setId(id);
        return forumPostStatistic;
    }

    public static ForumPostStatistic buildComments(Long id, Integer commendCount) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setCommentCount(commendCount);
        forumPostStatistic.setId(id);
        return forumPostStatistic;
    }

    public static ForumPostStatistic buildShares(Long id, Integer shareCount) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setShareCount(shareCount);
        forumPostStatistic.setRealShareCount(shareCount);
        forumPostStatistic.setId(id);
        return forumPostStatistic;
    }

    public static ForumPostStatistic buildVirtualShares(Long id, Integer shareCount) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setShareCount(shareCount);
        forumPostStatistic.setId(id);
        return forumPostStatistic;
    }


}