package com.bxm.localnews.news.model.vo;

import com.bxm.localnews.news.model.dto.NewsReplyDTO;
import com.bxm.localnews.news.model.dto.VoteDetailDTO;
import com.bxm.localnews.news.model.dto.activity.PostActivityExtendDTO;
import com.bxm.localnews.news.model.dto.grain.GrainInfoDTO;
import com.bxm.localnews.news.model.dto.hotpost.ShareCashExtendDTO;
import com.bxm.localnews.news.model.vo.topic.TopicHotForumGuideInfo;
import com.bxm.localnews.news.model.vo.topic.TopicVo;
import com.bxm.localnews.news.vo.PostImgVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel(description = "帖子详情")
@Data
public class ForumPostVo {
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("帖子标题")
    private String title;

    @ApiModelProperty("作者id")
    private Long userId;

    @ApiModelProperty("发帖地址")
    private String location;

    @ApiModelProperty("帖子内容,HTML格式")
    private String content;

    @ApiModelProperty("帖子内容,纯文本格式，从content中提取")
    private String textField;

    @ApiModelProperty("在站外访问时是否强引导下载  0:否 1:是")
    private Byte isBootDownload;

    @ApiModelProperty("当前用户是否已点赞：0否 1是")
    private Integer liked;

    @ApiModelProperty("阅读数")
    private Integer clickCount;

    @ApiModelProperty("评论数")
    private Integer commentCount;

    @ApiModelProperty("分享数")
    private Integer shareCount;

    @ApiModelProperty("收藏数")
    private Integer collectCount;

    @ApiModelProperty("点赞次数")
    private Integer likeCount;

    @ApiModelProperty("审核状态：1通过 2审核中 3拒绝 ... 100:限制内容被访问")
    private Integer status;

    @ApiModelProperty("1.2.0 推广状态，0：未推广，1：推广中，2：推广结束")
    private Integer promotionStatus;

    @ApiModelProperty("帖子分享链接")
    private String shareUrl;

    @ApiModelProperty("当前帖子对应的话题列表")
    private List<TopicVo> topicList;

    @ApiModelProperty("当前帖子的热评")
    private List<NewsReplyDTO> hotReplyDesc;

    @ApiModelProperty(value = "展示时间（今天、明天）")
    private String displayTime;

    @ApiModelProperty(value = "展示时间", hidden = true)
    private Date displayDateTime;

    @ApiModelProperty("内容中的图片")
    private List<PostImgVo> postContentImgList;

    @ApiModelProperty(value = "内容中的图片", hidden = true)
    @JsonIgnore
    private List<PostImgVo> postImgList;

    @ApiModelProperty("分享图片")
    private PostImgVo shareImg;

    @ApiModelProperty("推荐话题，如果不为空，则说明当前信息流需要渲染为帖子的格式")
    private TopicVo recommendTopicVo;

    @ApiModelProperty("帖子内容前增加额外的跳转链接（夺宝活动炫耀帖等情况）")
    private ExtJumpInfo extJumpInfo;

    @ApiModelProperty("1.2.0 当前帖子是否有开仓放粮的信息，可能为空，在列表和详情中使用")
    private GrainInfoDTO grainInfo;

    /**
     * ======================================================
     * 以下为不需要显示给客户端的历史字段
     * ======================================================
     */
    @ApiModelProperty(value = "有效阅读总数（3.8.0定义为真实阅读数量）", hidden = true)
    @JsonIgnore
    private Long reviewCount;

    @ApiModelProperty(value = "初始基数", hidden = true)
    @JsonIgnore
    private Long initialBasicNum;

    @ApiModelProperty(value = "帖子所属话题ID列表", hidden = true)
    @JsonIgnore
    private String topicIds;

    @Deprecated
    @ApiModelProperty(value = "到期时间 3.4.0版本之后小纸条暂时移除失效时间", hidden = true)
    @JsonIgnore
    private Date validDate;

    @ApiModelProperty(value = "马甲号类型 0:正常用户 1:评论马甲  2:发帖马甲 3:普通陪聊 4:地方大V 5:全国大V", hidden = true)
    @JsonIgnore
    private Byte vestType;

    @ApiModelProperty(value = "启用占位符 0 未启用 1启用", hidden = true)
    @JsonIgnore
    private Byte enablePlaceholder;

    @ApiModelProperty(value = "更新时间", hidden = true)
    @JsonIgnore
    private Date modifyTime;

    @ApiModelProperty(value = "创建时间", hidden = true)
    @JsonIgnore
    private Date createTime;

    @ApiModelProperty(value = "发布时间", hidden = true)
    @JsonIgnore
    private Date publishTime;

    @ApiModelProperty(value = "当前用户是否已收藏：0否 1是", hidden = true)
    @JsonIgnore
    private Integer collected;

    @ApiModelProperty(value = "该帖子最终需要达到的用户阅读数量（由真实阅读数量计算而来）", hidden = true)
    @JsonIgnore
    private Long finalClickCount;

    @ApiModelProperty(value = "更多评论数", hidden = true)
    @JsonIgnore
    private Integer moreCommentCount;

    @ApiModelProperty(value = "帖子封面图片", hidden = true)
    @JsonIgnore
    private String coverList;

    @ApiModelProperty(value = "推荐次数", hidden = true)
    @JsonIgnore
    private Integer recommendCount;

    @ApiModelProperty(value = "封面选择 0:只取图片 1:只取第一个视频  2:取内容详情的视频和图片", hidden = true)
    @JsonIgnore
    private Integer coverSelect;

    @ApiModelProperty(value = "地区编码", hidden = true)
    @JsonIgnore
    private String areaCode;

    @ApiModelProperty(value = "[已废弃]编辑寄语", hidden = true)
    @JsonIgnore
    @Deprecated
    private String editorMessage;

    @ApiModelProperty(value = "编辑寄语ID", hidden = true)
    @JsonIgnore
    private Long editorMessageId;

    /**
     * ================================================================
     * 还返回给前端，但是已经不支持的历史业务，也不在API中显示了
     * ================================================================
     */
    @ApiModelProperty(value = "创建人id，运营人员添加时才有值", hidden = true)
    private Long creator;

    @ApiModelProperty(value = "[已废弃]展示标签：1热 2爆 3自定义", hidden = true)
    private Byte displayTag;

    @ApiModelProperty(value = "[已废弃]自定义标签内容", hidden = true)
    private String labelDiv;

    @ApiModelProperty(value = "投放类型 0全国 1地区", hidden = true)
    private Integer deliveryType;

    @ApiModelProperty(value = "是否用户修改", hidden = true)
    private Byte isUserUpdate;

    @ApiModelProperty(value = "用户是否首次发帖 0 否 1是", hidden = true)
    private Byte isFirstUserPost = 0;

    @ApiModelProperty(value = "[已废弃]现金奖励金额", hidden = true)
    private BigDecimal cashReward;

    @ApiModelProperty(value = "3.10.0需求-话题页 “最新”tab顶部引导到“最热”tab数据内容", hidden = true)
    private TopicHotForumGuideInfo topicHotForumGuideInfo;

    @ApiModelProperty(value = "分享得现金奖励帖子的额外扩展字段", hidden = true)
    private ShareCashExtendDTO shareCashExtendDTO;

    @ApiModelProperty(value = "活动帖子的额外扩展字段", hidden = true)
    private PostActivityExtendDTO postActivityExtendDTO;

    @ApiModelProperty(value = "是否精华帖：0否 1是", hidden = true)
    private Integer isBrilliant;

    @ApiModelProperty(value = "是否本地爆料：0否 1是", hidden = true)
    private Byte isBroke;

    @ApiModelProperty(value = "是否优质头条：0否 1是", hidden = true)
    private Byte isRecommend;

    @ApiModelProperty(value = "是否红色章：0否 1是", hidden = true)
    private Integer isRed;

    @ApiModelProperty(value = "是否奖励现金：0否 1是", hidden = true)
    private Integer isCash;

    @ApiModelProperty(value = "是否分享奖励现金：0否 1是", hidden = true)
    private Integer shareCash;

    @ApiModelProperty(value = "是否活动帖子：0否 1是", hidden = true)
    private Integer activityPost;

    @ApiModelProperty(value = "投票插件信息，可能为空", hidden = true)
    private VoteDetailDTO voteDetailDTO;

    @ApiModelProperty(value = "帖子插件信息", hidden = true)
    private List<ForumPlugin> plugins;
}
