package com.bxm.localnews.news.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(description = "小纸条详情")
public class NotePublishVo {

    @ApiModelProperty("用户可发布次数")
    private Integer publishNum;

    @ApiModelProperty("轮播数据")
    private List<NoteVo> carouselList;

    @ApiModelProperty("小纸条引导文案 eg: 你可以写这样的纸条：\n" +
            "今天天气不错有没有人出去爬山\n" +
            "小孩子要入学需要准备哪些手续\n" +
            "想一份离家近的工作\n" +
            "\n" +
            "写好的纸条会在广德人列表展示哦")
    private String guidance;

}
