package com.bxm.localnews.news.model.vo.hotpost;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/12 4:24 下午
 */
@Data
@ApiModel("我发布的热文信息VO")
public class HotPostItemVO {
    @ApiModelProperty("帖子标题")
    private String postTitle;

    @ApiModelProperty("帖子id")
    private Long postId;

    @ApiModelProperty("分享次数")
    private Integer shareCount;

    @ApiModelProperty("已发奖金")
    private BigDecimal sentAward;

    @ApiModelProperty("我的奖金")
    private BigDecimal myAward;

    @ApiModelProperty("预览图片地址")
    private String previewImg;

    @ApiModelProperty("帖子描述")
    private String postDesc;

    @ApiModelProperty("帖子分享url")
    private String shareUrl;

    @ApiModelProperty(value = "帖子文本内容", hidden = true)
    private String postTextField;
}