package com.bxm.localnews.news.model.vo.hotpost;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.Date;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/19 5:17 下午
 */
@Data
@Builder
public class HotPostReadDataDTO {

    @ApiModelProperty("帖子id")
    private Long postId;

    @ApiModelProperty("阅读用户openid")
    private String openid;

    @ApiModelProperty("分享帖子的受益人用户id")
    private Long shareUserId;

    @ApiModelProperty("上报的日期")
    private Date reportDate;

    @ApiModelProperty("用户userAgent")
    private String userAgent;

    @ApiModelProperty("用户ip")
    private String ip;

    @ApiModelProperty("分享人的地区编码")
    private String areaCode;

    @Tolerate
    public HotPostReadDataDTO() {
    }
}