package com.bxm.localnews.news.model.vo.topic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * @author pf.w
 * @date 2020/12/10 14:35
 **/
@ApiModel(description = "头条话题推荐下的帖子基础信息")
@Data
@Builder
public class TopicForumInfo {

    @ApiModelProperty("帖子ID")
    private Long newsId;

    @ApiModelProperty("帖子头图")
    private String img;

    @ApiModelProperty("发帖用户ID")
    private Long userId;

    @ApiModelProperty("发帖用户昵称")
    private String nickName;

    @ApiModelProperty("头像地址")
    private String headImg;

    @Tolerate
    public TopicForumInfo() {

    }
}
