package com.bxm.localnews.news.model.vo.topic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(description = "话题")
public class TopicVo {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("描述")
    private String descp;

    @ApiModelProperty("图标")
    private String img;

    @ApiModelProperty("参与人数")
    private Long participantsNum;

    @ApiModelProperty("小程序分享路由")
    private String appletShareUrl;

    @ApiModelProperty("h5分享链接")
    private String shareUrl;

    @ApiModelProperty("话题下引导用户发帖的按钮上的文案")
    private String leadPostContent;

    @ApiModelProperty("头条/本地圈推荐语")
    private String recommendContent;

    @ApiModelProperty("参与者代号（话题内的发帖人别称，如：达人们）")
    private String joinCode;

    @ApiModelProperty("参与者头像列表")
    private List<String> joinHeadImgList;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("用户发帖选择该话题时的引导性质文案")
    private String forumPostGuide;

    @ApiModelProperty("奖励有效时间 开始时间")
    private Date rewardStartTime;

    @ApiModelProperty("奖励有效时间结束时间")
    private Date rewardEndTime;

    @ApiModelProperty("是否热门 0：否 1：是")
    private Integer hot;

    @ApiModelProperty("需求 类型弹窗文案填充")
    private String guidePopText;

    @ApiModelProperty("二级分类信息")
    List<TopicSecondInfo> topicSecondInfoList;

    @ApiModelProperty("需求 是否有奖 0：无  |  1：有")
    private Integer hasReward = 0;

    @ApiModelProperty("需求 奖励描述")
    private String rewardDesc;

    @ApiModelProperty("需求 话题下帖子基础信息集合")
    private List<TopicForumInfo> topicForums;
}
