/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.comment.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.param.UserWarmActionParam;
import com.bxm.foundation.base.facade.service.SensitiveWordFacadeService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MessageService;
import com.bxm.localnews.integration.PushMsgService;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.UserWarmIntegrationService;
import com.bxm.localnews.integration.VirtualUserIntegrationService;
import com.bxm.localnews.news.comment.NewNewsReplyService;
import com.bxm.localnews.news.comment.service.CommentFacadeService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.MemoryCacheKey;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.convert.NewsReplyConver;
import com.bxm.localnews.news.detail.helper.ForumPostImageHelper;
import com.bxm.localnews.news.domain.AdminNewsReplyMapper;
import com.bxm.localnews.news.domain.NewsReplyLikeMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.dto.LocationDTO;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.ReplyStatusEnum;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.event.CommentActionEvent;
import com.bxm.localnews.news.event.ReplyAccessApplicationEvent;
import com.bxm.localnews.news.event.UserActionEvent;
import com.bxm.localnews.news.facade.service.ForumPostInnerService;
import com.bxm.localnews.news.facade.service.ForumPostTotalFacadeService;
import com.bxm.localnews.news.factory.ExtendFactory;
import com.bxm.localnews.news.model.dto.NewsReplyDTO;
import com.bxm.localnews.news.model.dto.NewsReplyDetailDTO;
import com.bxm.localnews.news.model.dto.NewsReplyListDTO;
import com.bxm.localnews.news.model.dto.ReplyDTO;
import com.bxm.localnews.news.model.dto.ReplyPostDTO;
import com.bxm.localnews.news.model.entity.ForumPostTotalEntity;
import com.bxm.localnews.news.model.param.NewsReplyAddParam;
import com.bxm.localnews.news.model.param.NewsReplyLikeParam;
import com.bxm.localnews.news.model.param.NewsReplyParam;
import com.bxm.localnews.news.model.param.UserReplyParam;
import com.bxm.localnews.news.model.vo.AdminNewsReply;
import com.bxm.localnews.news.model.vo.ForumPostStatistic;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.MyReplysVO;
import com.bxm.localnews.news.model.vo.NewsReplayLike;
import com.bxm.localnews.news.model.vo.NewsReply;
import com.bxm.localnews.news.model.vo.NewsReplyBaseVO;
import com.bxm.localnews.news.model.vo.UserReply;
import com.bxm.localnews.news.model.vo.VirtualUser;
import com.bxm.localnews.news.thread.PostReplyThread;
import com.bxm.localnews.news.util.AtUserIdExtractUtils;
import com.bxm.localnews.news.util.FormPostContentUtil;
import com.bxm.localnews.news.util.ReplyUtils;
import com.bxm.localnews.news.utils.CommentUtil;
import com.bxm.localnews.news.vo.ForumReplyInfo;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.enums.PlatformEnum;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.tools.DateBeautifyUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.event.EventListener;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class NewNewsReplyServiceImpl
extends BaseService
implements NewNewsReplyService {
    private static final Logger log = LoggerFactory.getLogger(NewNewsReplyServiceImpl.class);
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private NewsReplyLikeMapper newsReplyLikeMapper;
    @Resource
    private RedisListAdapter redisListAdapter;
    @Resource
    private UserReplyMapper userReplyMapper;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private MessageService messageService;
    @Resource
    private NewsReplyConver newsReplyConver;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private SensitiveWordFacadeService sensitiveWordFacadeService;
    @Resource
    private EventBus userActionEventBus;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private AsyncTaskExecutor asyncTaskExecutor;
    @Resource
    private CommentFacadeService commentFacadeService;
    @Resource
    private AdminNewsReplyMapper adminNewsReplyMapper;
    @Resource
    private ForumPostImageHelper forumPostImageHelper;
    @Resource
    private CacheHolder cacheHolder;
    @Resource
    private PushMsgService pushMsgService;
    @Resource
    private ForumProperties forumProperties;
    @Resource
    private UserWarmIntegrationService userWarmIntegrationService;
    @Resource
    private VirtualUserIntegrationService virtualUserIntegrationService;
    @Resource
    private AsyncTaskExecutor taskExecutor;
    @Resource
    private ForumPostInnerService forumPostInnerService;
    @Resource
    private ForumPostTotalFacadeService forumPostTotalFacadeService;
    @Resource
    private UserAuthIntegrationService userAuthIntegrationService;

    @Override
    public PageWarper<NewsReplyDTO> queryReplyList(NewsReplyParam newsReplyParam, BasicParam basicParam) {
        List<NewsReplyDTO> allReplyList = this.newsReplyMapper.queryAllReplyWithContent(newsReplyParam.getNewsId(), newsReplyParam.getUserId());
        allReplyList = this.commentFacadeService.execReplyLogic((List)allReplyList, newsReplyParam, false);
        boolean isOutWeb = basicParam.getPlatform() == 3;
        int start = newsReplyParam.getPageSize() * (newsReplyParam.getPageNum() - 1);
        int total = allReplyList.size();
        allReplyList = allReplyList.stream().skip(start).limit(newsReplyParam.getPageSize().intValue()).collect(Collectors.toList());
        allReplyList.forEach(replyDTO -> {
            ReplyUtils.processReplyContent((NewsReplyBaseVO)replyDTO, (boolean)isOutWeb);
            replyDTO.getList().forEach(sub -> ReplyUtils.processReplyContent((NewsReplyBaseVO)sub, (boolean)isOutWeb));
        });
        PageWarper result = new PageWarper(allReplyList);
        result.setTotal((long)total);
        int currentIndex = start + newsReplyParam.getPageSize();
        result.setHasNextPage(currentIndex < total);
        result.setIsLastPage(!result.isHasNextPage());
        return result;
    }

    private boolean isLike(Long userId, Long replyId) {
        return null != this.newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
    }

    @Override
    public Json<ReplyDTO> doReply(NewsReplyAddParam newsReplyAddParam, BasicParam basicParam) {
        Long userId;
        Message message;
        if (log.isDebugEnabled()) {
            log.debug("[doReply]\u53d1\u8868\u8bc4\u8bba\uff0c\u53c2\u6570:[{}]", (Object)JSON.toJSONString((Object)newsReplyAddParam));
        }
        if (!(message = this.userAuthIntegrationService.hasCommentAuth(newsReplyAddParam.getUserId())).isSuccess()) {
            return Json.badReqeuset((String)message.getLastMessage());
        }
        List badWords = this.sensitiveWordFacadeService.match(newsReplyAddParam.getReplyContent(), false, false);
        if (badWords.size() > 0) {
            return ResultUtil.genFailedResult((String)("\u60a8\u53d1\u8868\u7684\u8bc4\u8bba\u4e2d\u6709\u654f\u611f\u5185\u5bb9[" + (String)badWords.get(0) + "]\uff0c\u8bf7\u4fee\u6539"));
        }
        NewsReply newsReply = this.newsReplyConver.convert(newsReplyAddParam);
        this.newsReplyMapper.insertSelective(newsReply);
        if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType().byteValue() && null != (userId = this.forumPostInnerService.getPostUserId(newsReply.getNewsId()))) {
            newsReply.setUserIsAuthor(Boolean.valueOf(userId.equals(newsReply.getUserId())));
            newsReply.setParentUserIsAuthor(Boolean.valueOf(userId.equals(newsReply.getParentUserId())));
        }
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties((Object)newsReply, (Object)userReply);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237userId=[{}]\u53d1\u8868\u8bc4\u8bba,userReply\u53c2\u6570:[{}]", (Object)userReply.getUserId(), (Object)JSON.toJSONString((Object)userReply));
        }
        this.userReplyMapper.insertSelective(userReply);
        newsReply.setReplyTime(DateBeautifyUtils.timeConvertString((Date)newsReply.getAddTime()));
        NewsReply param = new NewsReply();
        BeanUtils.copyProperties((Object)newsReply, (Object)param);
        this.updateComment(newsReply);
        this.userIntegrationService.addUserStatisticsNum(newsReplyAddParam.getUserId(), Integer.valueOf(3));
        if (log.isDebugEnabled()) {
            log.debug("=======reply : {} ", (Object)param);
        }
        this.taskExecutor.execute(() -> this.processWhenReply(param, newsReplyAddParam, basicParam.getPlatform(), newsReplyAddParam.getAreaCode()));
        if (newsReply.getLevel().equals(NewsConstant.REPLY_LEVEL_1) && basicParam.getPlatform().intValue() != PlatformEnum.APPLET.getCode()) {
            newsReply.setParentUserId(null);
            newsReply.setParentUserNickname(null);
        }
        ReplyDTO result = new ReplyDTO();
        BeanUtils.copyProperties((Object)newsReply, (Object)result);
        result.setReplyContent(newsReply.getReplyContentHtml());
        return Json.build((Object)result);
    }

    private void clearCache(Long newsId) {
        if (null == newsId) {
            return;
        }
        this.cacheHolder.sendEvictCmd(MemoryCacheKey.HOT_REPLY_CACHE, (Object[])new Long[]{newsId});
        this.cacheHolder.sendEvictCmd(MemoryCacheKey.REPLY_COUNT_CACHE, (Object[])new Long[]{newsId});
    }

    @Override
    public void saveForumPostReplyRecord(Long userId, Long postId, Date sendTime) {
        Date expireTime = this.getExpireTime();
        KeyGenerator postKey = RedisConfig.FORUM_REPLY_POSTID.copy();
        this.redisSetAdapter.add(postKey, new Object[]{postId});
        this.redisListAdapter.expire(postKey, expireTime);
        ForumReplyInfo info = ForumReplyInfo.builder().userId(userId).replyTime(sendTime).build();
        KeyGenerator infoKey = RedisConfig.FORUM_REPLY_INFO.copy().appendKey((Object)postId);
        this.redisListAdapter.leftPush(infoKey, new Object[]{info});
        this.redisListAdapter.expire(infoKey, expireTime);
    }

    private Date getExpireTime() {
        Calendar current = Calendar.getInstance();
        int hour = current.get(11);
        Calendar expired = Calendar.getInstance();
        expired.set(12, 2);
        expired.set(13, 0);
        if (hour < 9) {
            expired.set(11, 9);
        } else if (hour < 12) {
            expired.set(11, 12);
        } else if (hour < 18) {
            expired.set(11, 18);
        } else if (hour < 21) {
            expired.set(11, 21);
        } else {
            expired.add(5, 1);
            expired.set(11, 9);
        }
        return expired.getTime();
    }

    @Override
    @Async
    public void processWhenReply(NewsReply newsReply, NewsReplyAddParam newsReplyAddParam, Integer platform, String areaCode) {
        try {
            this.clearCache(newsReply.getNewsId());
            if (StringUtils.isBlank((CharSequence)newsReply.getReplyImg())) {
                this.processWhenReplySuccess(newsReply);
            }
        }
        catch (Exception e) {
            log.error("\u5e16\u5b50\u8bc4\u8bba\u63a8\u9001\u5f02\u6b65\u5904\u7406\u5931\u8d25 newsReply: {}, newsReplyAddParam: {}, platform: {}, areaCode: {}", new Object[]{JSON.toJSONString((Object)newsReply), JSON.toJSONString((Object)newsReplyAddParam), JSON.toJSONString((Object)platform), JSON.toJSONString((Object)areaCode), e});
        }
    }

    @Override
    public void processWhenReplySuccess(NewsReply newsReply) {
        try {
            ForumPostVo forumPostVo = null;
            LocationDTO location = this.locationIntegrationService.getLocationByGeocode(newsReply.getAreaCode());
            if (Objects.nonNull(newsReply.getRootId()) && newsReply.getRootId() != 0L) {
                NewsReply rootReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
                Integer interactiveCount = rootReply.getInteractiveCount();
                interactiveCount = Objects.isNull(interactiveCount) || interactiveCount == 0 ? 3 : interactiveCount + 3;
                rootReply.setInteractiveCount(interactiveCount);
                this.newsReplyMapper.updateByPrimaryKeySelective(rootReply);
                UserReply userRootReply = new UserReply();
                BeanUtils.copyProperties((Object)rootReply, (Object)userRootReply);
                this.userReplyMapper.updateinteractiveCountById(userRootReply);
            }
            if (Objects.nonNull(newsReply.getParentUserId()) && !newsReply.getParentUserId().equals(newsReply.getUserId())) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5c01\u88c5\u7684\u6d88\u606f\u683c\u5f0f\u4e3a\uff1a[{}]", (Object)JSON.toJSONString((Object)newsReply));
                }
                if (newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
                    forumPostVo = this.forumPostInnerService.getBriefInfo(newsReply.getNewsId());
                    FormPostContentUtil.replace((ForumPostVo)forumPostVo, (LocationDTO)location);
                    this.forumPostImageHelper.exchangeDetailPost(forumPostVo);
                    this.messageService.pushNewReplyMessage(newsReply, PushMessageEnum.POST_REPLY, forumPostVo);
                }
            }
            if (null == newsReply.getParentUserId() && newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
                if (Objects.isNull(forumPostVo)) {
                    forumPostVo = this.forumPostInnerService.getBriefInfo(newsReply.getNewsId());
                }
                FormPostContentUtil.replace(forumPostVo, (LocationDTO)location);
                this.forumPostImageHelper.exchangeDetailPost(forumPostVo);
                this.messageService.pushPostReplyMessage(newsReply, forumPostVo);
            }
            UserActionEvent userActionEvent = CommentActionEvent.of().setLastCommentTime(new Date()).setTargetId(newsReply.getNewsId()).setUserId(newsReply.getUserId());
            this.userActionEventBus.post((Object)userActionEvent);
            if (StringUtils.isNotBlank((CharSequence)newsReply.getReplyContent()) && newsReply.getReplyContent().contains("@")) {
                this.pushPostReplyATMessage(newsReply, forumPostVo);
            }
            this.handOutWarm(newsReply.getUserId(), WarmRuleEnum.COMMENT);
            this.clearCache(newsReply.getNewsId());
            if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType().byteValue()) {
                this.saveForumPostReplyRecord(newsReply.getUserId(), newsReply.getNewsId(), new Date());
            }
        }
        catch (Exception e) {
            log.error("\u5e16\u5b50\u8bc4\u8bba\u63a8\u9001\u5f02\u6b65\u5904\u7406\u5931\u8d25 newsReply: {}", (Object)JSON.toJSONString((Object)newsReply), (Object)e);
        }
    }

    @Override
    public void pushPostReplyATMessage(NewsReply newsReply, ForumPostVo forumPostVo) {
        if (Objects.isNull(forumPostVo)) {
            forumPostVo = this.forumPostInnerService.getBriefInfo(newsReply.getNewsId());
        }
        Document document = Jsoup.parse((String)("<p>" + newsReply.getReplyContentHtml() + "</p>"));
        List userIds = AtUserIdExtractUtils.processAtInfo((Document)document);
        userIds = Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)userIds));
        if (log.isDebugEnabled()) {
            log.debug("\u5e16\u5b50\u8bc4\u8bba: {} \u4e2d\u5305\u542b@\u7528\u6237\u6570\u636e\uff0c\u7ed9\u7528\u6237: {} \u63a8\u9001", (Object)newsReply.getReplyContentHtml(), (Object)userIds);
        }
        this.messageService.pushPostReplyATMessage(newsReply, forumPostVo, userIds);
    }

    @EventListener(value={ReplyAccessApplicationEvent.class})
    public void onReplyAccessApplicationEvent(ReplyAccessApplicationEvent event) {
        try {
            NewsReply newsReply;
            if (log.isDebugEnabled()) {
                log.debug("\u63a5\u6536\u5230\u8bc4\u8bba\u5ba1\u6838\u901a\u8fc7\u7684\u4e8b\u4ef6\uff0cevent: {}", (Object)JSON.toJSONString((Object)event));
            }
            if (Objects.isNull(newsReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(event.getReplyId(), event.getNewsId()))) {
                log.warn("event: {} \u65e0\u6cd5\u83b7\u53d6\u5230\u8bc4\u8bba\u4fe1\u606f\uff0c \u65e0\u6cd5\u8fdb\u884c\u63a8\u9001", (Object)JSON.toJSONString((Object)event));
                return;
            }
            this.taskExecutor.execute(() -> this.processWhenReplySuccess(newsReply));
        }
        catch (Exception e) {
            log.error("\u63a5\u6536\u5230\u8bc4\u8bba\u5ba1\u6838\u901a\u8fc7\u7684\u4e8b\u4ef6\u51fa\u73b0\u9519\u8bef\uff0cevent: {}", (Object)JSON.toJSONString((Object)event), (Object)e);
        }
    }

    @Override
    public void updateComment(NewsReply newsReply) {
        int count = this.newsReplyMapper.selectCountByNewsId(newsReply.getNewsId());
        if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType().byteValue()) {
            ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildComments((Long)newsReply.getNewsId(), (Integer)count);
            List replyList = this.newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(newsReply.getNewsId());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)replyList)) {
                forumPostStatistic.setReplyInfo(JSON.toJSONString((Object)replyList));
            }
            ForumPostTotalEntity entity = ForumPostTotalEntity.builder().commentCount(Integer.valueOf(count)).postId(newsReply.getNewsId()).build();
            this.forumPostTotalFacadeService.updateField(entity);
        }
    }

    @Override
    public PageWarper<MyReplysVO> selectMyReplys(UserReplyParam newsReplyParam, BasicParam basicParam) {
        PageWarper myReplysVOPageWarper = new PageWarper(this.userReplyMapper.selectMyReplys(newsReplyParam));
        List myReplysVOList = myReplysVOPageWarper.getList();
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(newsReplyParam.getAreaCode());
        boolean isOutWeb = basicParam.getPlatform() == 3;
        for (MyReplysVO myReplysVO : myReplysVOList) {
            ForumPostVo forumPostVo;
            Date addTime = myReplysVO.getAddTime();
            String replyTime = DateBeautifyUtils.timeConvertString((Date)addTime);
            myReplysVO.setReplyTime(replyTime);
            Byte type = myReplysVO.getType();
            if (type.byteValue() == ReplyTypeEnum.POST_REPLY.getCode() && null != (forumPostVo = this.forumPostInnerService.getBriefInfo(myReplysVO.getNewsId()))) {
                FormPostContentUtil.replace((ForumPostVo)forumPostVo, (LocationDTO)location);
                this.forumPostImageHelper.exchangeDetailPost(forumPostVo);
                ReplyPostDTO replyPostDTO = this.getForumPostReplyDto(forumPostVo);
                myReplysVO.setReplyPostDto(replyPostDTO);
                myReplysVO.setTitle(ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            }
            ReplyUtils.processReplyContent((MyReplysVO)myReplysVO, (boolean)isOutWeb);
        }
        return myReplysVOPageWarper;
    }

    @Override
    public NewsReplyDTO delMyReply(Long replyId, Long userId, Long newsId, Byte isUserDelete) {
        NewsReply newsReply = null;
        if (null != newsId && 0L != newsId) {
            newsReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId);
        }
        if (Objects.isNull(newsReply)) {
            newsReply = this.newsReplyMapper.selectByPrimaryKey(replyId);
        }
        Byte beforeReplyStatus = newsReply.getStatus();
        newsReply.setIsUserDelete(isUserDelete);
        this.replyRelationship(newsReply);
        NewsReplyDTO newsReplyDTO = new NewsReplyDTO();
        BeanUtils.copyProperties((Object)newsReply, (Object)newsReplyDTO);
        newsReplyDTO.setDeleteFlag(Byte.valueOf((byte)1));
        newsReplyDTO.setReplyTime(DateBeautifyUtils.timeConvertString((Date)newsReplyDTO.getAddTime()));
        newsReplyDTO.setReplyContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664\uff01");
        newsReplyDTO.setIsLike(Integer.valueOf(this.isLike(userId, replyId) ? 1 : 0));
        if (newsReply.getRootId() == 0L) {
            List replyMirrorDTOS = this.newsReplyMapper.selectSubReplyList(replyId, newsReply.getNewsId(), null);
            List replyLike = this.newsReplyMapper.selectReplyLike(newsReply.getNewsId(), userId, replyId);
            replyMirrorDTOS.forEach(e -> this.commentFacadeService.dealSubMirrorDTO(e, userId, replyLike));
            newsReplyDTO.setList(replyMirrorDTOS);
        }
        if (newsReply.getLevel() == 1) {
            newsReplyDTO.setParentUserId(null);
            newsReplyDTO.setParentUserNickname(null);
        }
        this.userIntegrationService.addUserStatisticsNum(userId, Integer.valueOf(4));
        this.updateComment(newsReply);
        this.clearCache(newsId);
        if (!Objects.equals(isUserDelete, (byte)1)) {
            this.pushMsgService.pushReplyDeleteAndRejectMsg(newsReply.getReplyContent(), newsReply.getUserId(), this.forumProperties.getOfficialRulePostId());
        }
        if (Objects.equals(ReplyStatusEnum.IS_SHOW.getCode(), beforeReplyStatus)) {
            this.handOutWarm(userId, Objects.equals(isUserDelete, (byte)1) ? WarmRuleEnum.ONESELF_DEL_COMMENT : WarmRuleEnum.OPERATE_DEL_COMMENT);
        }
        return newsReplyDTO;
    }

    private void handOutWarm(Long userId, WarmRuleEnum warmRuleEnum) {
        this.userWarmIntegrationService.updateWarm(UserWarmActionParam.builder().warmRuleEnum(warmRuleEnum).userId(userId).build());
    }

    private void replyRelationship(NewsReply newsReply) {
        this.userReplyMapper.deleteByPrimaryKey(newsReply.getId(), newsReply.getUserId(), newsReply.getIsUserDelete());
        if (newsReply.getRootId() == 0L) {
            List list = this.newsReplyMapper.selectSubReplyList(newsReply.getId(), newsReply.getNewsId(), null);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                newsReply.setDeleteFlag((byte)2);
                this.newsReplyMapper.updateByPrimaryKeySelective(newsReply);
            } else {
                this.newsReplyMapper.deleteByPrimaryKey(newsReply.getId(), newsReply.getNewsId(), newsReply.getIsUserDelete());
            }
        } else {
            this.newsReplyMapper.deleteByPrimaryKey(newsReply.getId(), newsReply.getNewsId(), newsReply.getIsUserDelete());
            List list = this.newsReplyMapper.selectSubReplyList(newsReply.getRootId(), newsReply.getNewsId(), null);
            NewsReply rootReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            if (rootReply.getDeleteFlag() != 0 && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                NewsReply record = new NewsReply();
                record.setId(newsReply.getRootId());
                record.setNewsId(newsReply.getNewsId());
                record.setDeleteFlag((byte)2);
                this.newsReplyMapper.updateByPrimaryKeySelective(record);
            }
        }
    }

    @Override
    @Async
    public void doTriggerUpdateInfo(Long userId, String nickname, String headImg) {
        List newsReplyList = this.newsReplyMapper.selectByUser(userId);
        for (NewsReply newsReply : newsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setUserNickname(nickname);
            newsReplyUp.setHeadImg(headImg);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)newsReplyUp, (Object)userReply);
            this.newsReplyMapper.updateUserInfo(newsReplyUp);
            this.userReplyMapper.updateUserInfo(userReply);
            this.clearCache(newsReply.getNewsId());
        }
        List parentNewsReplyList = this.newsReplyMapper.selectByParentUser(userId);
        for (NewsReply newsReply : parentNewsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setParentUserNickname(nickname);
            newsReplyUp.setParentHeadImg(headImg);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)newsReplyUp, (Object)userReply);
            this.newsReplyMapper.updateParentUserInfo(newsReplyUp);
            this.userReplyMapper.updateParentUserInfo(userReply);
            this.clearCache(newsReply.getNewsId());
        }
    }

    @Override
    public Message doProduceNewsReplyLike(NewsReplyLikeParam newsReplyLikeParam) {
        if (!this.checkLikeParam(newsReplyLikeParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u70b9\u8d5e\u7684\u53c2\u6570\u662f:{}", (Object)JSON.toJSONString((Object)newsReplyLikeParam));
        }
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");
        this.redisListAdapter.leftPush(keyGenerator, new Object[]{newsReplyLikeParam});
        this.callAsyncConsume();
        return Message.build((boolean)true);
    }

    private void callAsyncConsume() {
        NewNewsReplyService newsReplyService = (NewNewsReplyService)SpringContextHolder.getBean(NewNewsReplyService.class);
        newsReplyService.doNewsReplyLikeConsume();
    }

    @Override
    @Async
    public void doNewsReplyLikeConsume() {
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");
        NewsReplyLikeParam newsReplyLikeWarper = (NewsReplyLikeParam)this.redisListAdapter.rightPop(keyGenerator, NewsReplyLikeParam.class);
        if (null != newsReplyLikeWarper) {
            int count;
            if (log.isDebugEnabled()) {
                log.debug("\u65b0\u95fb\u56de\u590d\u70b9\u8d5e\u5f00\u59cb\u6d88\u8d39...");
            }
            int type = newsReplyLikeWarper.getType();
            NewsReply newsReply = null != newsReplyLikeWarper.getNewsId() && 0L != newsReplyLikeWarper.getNewsId() ? this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReplyLikeWarper.getReplyId(), newsReplyLikeWarper.getNewsId()) : this.newsReplyMapper.selectByPrimaryKey(newsReplyLikeWarper.getReplyId());
            if (newsReply != null && (count = this.saveReplyLiKeRecord(newsReply.getId(), newsReplyLikeWarper.getUserId(), type)) > 0 && type == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("\u8bc4\u8bba\u5b9e\u4f53:{}", JSONObject.toJSON((Object)newsReply));
                }
                int likeCount = this.generatorLikeCount(type, newsReply.getLikeCount());
                if (log.isDebugEnabled()) {
                    log.debug("\u70b9\u8d5e\u6570:{}", (Object)likeCount);
                }
                NewsReply newsReplyUp = new NewsReply();
                newsReplyUp.setId(newsReplyLikeWarper.getReplyId());
                newsReplyUp.setLikeCount(Integer.valueOf(likeCount));
                newsReplyUp.setUserId(newsReply.getUserId());
                newsReplyUp.setNewsId(newsReply.getNewsId());
                if (newsReply.getRootId() == 0L) {
                    newsReplyUp.setInteractiveCount(Integer.valueOf(newsReply.getInteractiveCount() + 1));
                }
                this.newsReplyMapper.updateByPrimaryKeySelective(newsReplyUp);
                UserReply userReply = new UserReply();
                BeanUtils.copyProperties((Object)newsReplyUp, (Object)userReply);
                this.userReplyMapper.updateinteractiveCountById(userReply);
                if (!newsReplyLikeWarper.getUserId().equals(newsReply.getUserId()) && newsReplyLikeWarper.getType() == 1) {
                    LocationDTO location = this.locationIntegrationService.getLocationByGeocode(newsReplyLikeWarper.getAreaCode());
                    if (newsReply.getType() == 3) {
                        ForumPostVo postVo = this.forumPostInnerService.getBriefInfo(newsReply.getNewsId());
                        FormPostContentUtil.replace((ForumPostVo)postVo, (LocationDTO)location);
                        this.forumPostImageHelper.exchangeDetailPost(postVo);
                        this.messageService.pushNewLikeMessage(newsReplyLikeWarper, PushMessageEnum.POST_LIKE, newsReply, postVo);
                    }
                }
                this.userIntegrationService.updateUserLikeNumByUserId(newsReply.getUserId());
                if (log.isDebugEnabled()) {
                    log.debug("\u8bc4\u8bba: {} \u662f\u5426\u662f\u70ed\u8bc4: {}", (Object)newsReply.getId(), (Object)newsReply.getHotReply());
                }
                if (Objects.equals(newsReply.getHotReply(), 1)) {
                    this.cacheHolder.sendEvictCmd(MemoryCacheKey.HOT_REPLY_CACHE, (Object[])new String[]{Objects.toString(newsReply.getNewsId())});
                }
            }
            this.doNewsReplyLikeConsume();
        }
    }

    @Override
    public NewsReplyDetailDTO getNewsReplyDetailDTO(Long replyId, Long userId, Long newsId, String areaCode, BasicParam basicParam) {
        NewsReply newsReply = null != newsId && 0L != newsId ? this.newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId) : this.newsReplyMapper.selectByPrimaryKey(replyId);
        if (Objects.isNull(newsReply) || Objects.isNull(newsReply.getRootId())) {
            return null;
        }
        if (newsReply.getRootId() != 0L) {
            newsReply = null != newsId && 0L != newsId ? this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsId) : this.newsReplyMapper.selectByPrimaryKey(newsReply.getRootId());
        }
        NewsReplyDetailDTO newsReplyDetailDTO = new NewsReplyDetailDTO();
        if (null != newsReply) {
            BeanUtils.copyProperties((Object)newsReply, (Object)newsReplyDetailDTO);
            if (this.isLike(userId, newsReplyDetailDTO.getId())) {
                newsReplyDetailDTO.setIsLike(Integer.valueOf(1));
            }
            newsReplyDetailDTO.setReplyTime(DateBeautifyUtils.timeConvertString((Date)newsReplyDetailDTO.getAddTime()));
            this.addSuperiorObject(newsReply, userId, newsReplyDetailDTO, areaCode);
            List replies = this.newsReplyMapper.selectSubReplyList(newsReply.getId(), newsReply.getNewsId(), userId);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)replies)) {
                replies.forEach(replay -> {
                    List replyLike = this.newsReplyMapper.selectReplyLike(replay.getNewsId(), userId, replyId);
                    this.commentFacadeService.dealSubMirrorDTO(replay, userId, replyLike);
                });
            }
            replies = CommentUtil.filter((List)replies, (Long)userId);
            newsReplyDetailDTO.setList(replies);
            boolean isOutWeb = basicParam.getPlatform() == 3;
            ReplyUtils.processReplyContent((NewsReplyBaseVO)newsReplyDetailDTO, (boolean)isOutWeb);
            replies.forEach(reply -> ReplyUtils.processReplyContent((NewsReplyBaseVO)reply, (boolean)isOutWeb));
        }
        return newsReplyDetailDTO;
    }

    private NewsReplyDetailDTO addSuperiorObject(NewsReply newsReply, Long userId, NewsReplyDetailDTO newsReplyDetailDTO, String areaCode) {
        Byte type = newsReply.getType();
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        if (type.byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
            ForumPostVo forumPostVo = this.forumPostInnerService.getBriefInfo(newsReply.getNewsId());
            FormPostContentUtil.replace((ForumPostVo)forumPostVo, (LocationDTO)location);
            if (null != forumPostVo) {
                ReplyPostDTO replyPostDTO = this.getForumPostReplyDto(forumPostVo);
                newsReplyDetailDTO.setReplyPostDto(replyPostDTO);
                newsReplyDetailDTO.setTitle(ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            }
        }
        return newsReplyDetailDTO;
    }

    private ReplyPostDTO getForumPostReplyDto(ForumPostVo forumPostVo) {
        ReplyPostDTO replyPostDTO = new ReplyPostDTO();
        replyPostDTO.setId(forumPostVo.getId());
        replyPostDTO.setStatus(Byte.valueOf((byte)forumPostVo.getStatus().intValue()));
        replyPostDTO.setTitle(forumPostVo.getTitle());
        replyPostDTO.setPostImgList(forumPostVo.getPostImgList());
        return replyPostDTO;
    }

    private int generatorLikeCount(int type, int likeCount) {
        if (0 == type) {
            if (likeCount > 0) {
                --likeCount;
            }
        } else {
            ++likeCount;
        }
        return likeCount;
    }

    private int saveReplyLiKeRecord(Long replyId, Long userId, int type) {
        int count = 0;
        NewsReplayLike newsReplayLike = this.newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
        if (type == 1) {
            if (null == newsReplayLike) {
                NewsReplayLike newsReplayLikeNew = new NewsReplayLike();
                newsReplayLikeNew.setAddTime(new Date());
                newsReplayLikeNew.setId(SequenceHolder.nextLongId());
                newsReplayLikeNew.setReplyId(replyId);
                newsReplayLikeNew.setUserId(userId);
                count = this.newsReplyLikeMapper.insert(newsReplayLikeNew);
            }
        } else if (null != newsReplayLike) {
            count = this.newsReplyLikeMapper.deleteByPrimaryKey(newsReplayLike.getId());
        }
        return count;
    }

    private boolean checkLikeParam(NewsReplyLikeParam newsReplyLikeParam) {
        return null != newsReplyLikeParam.getReplyId() && null != newsReplyLikeParam.getUserId();
    }

    @Override
    public Boolean doDealHistoryReply() {
        this.newsReplyMapper.deleteNewsReply();
        List userList = this.virtualUserIntegrationService.getRandom(Integer.valueOf(1000));
        for (int i = 0; i < 10; ++i) {
            String tableName = "t_news_reply_" + i;
            List replyList = this.newsReplyMapper.selectByUserIdIsZero(tableName);
            this.dealReplyList(replyList, userList);
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statisticalPostReply() {
        KeyGenerator postIdKey = RedisConfig.FORUM_REPLY_POSTID.copy();
        try {
            int threadNum = 10;
            Set postIds = this.redisSetAdapter.getAllMembers(postIdKey, (TypeReference)new TypeReference<Long>(){});
            CountDownLatch countDownLatch = new CountDownLatch(threadNum);
            int i = 0;
            while (i < threadNum) {
                int j = i++;
                List<Long> collect = postIds.stream().filter(e -> e % (long)threadNum == (long)j).collect(Collectors.toList());
                this.asyncTaskExecutor.execute((Runnable)new PostReplyThread(collect, countDownLatch));
            }
            countDownLatch.await();
        }
        catch (InterruptedException e2) {
            log.error("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", (Throwable)e2);
        }
        finally {
            this.redisSetAdapter.remove(postIdKey);
        }
    }

    @Override
    public NewsReplyListDTO replyList(NewsReplyParam param, BasicParam basicParam) {
        NewsReplyListDTO result = new NewsReplyListDTO();
        result.setHotReplys(this.commentFacadeService.getHotReplays(param));
        result.setHotReplys(this.commentFacadeService.execReplyLogic(result.getHotReplys(), param, true));
        PageWarper<NewsReplyDTO> newsReplyDTOPageWarper = this.queryReplyList(param, basicParam);
        result.setReplys(newsReplyDTOPageWarper);
        boolean isOutWeb = basicParam.getPlatform() == 3;
        result.getHotReplys().forEach(hotReply -> {
            ReplyUtils.processReplyContent((NewsReplyBaseVO)hotReply, (boolean)isOutWeb);
            if (!CollectionUtils.isEmpty((Collection)hotReply.getList())) {
                hotReply.getList().forEach(hotSubReply -> ReplyUtils.processReplyContent((NewsReplyBaseVO)hotSubReply, (boolean)isOutWeb));
            }
        });
        return result;
    }

    private void dealReplyList(List<NewsReply> replyList, List<VirtualUser> userList) {
        replyList.forEach(e -> {
            int random = ThreadLocalRandom.current().nextInt(0, userList.size());
            VirtualUser userInfo = (VirtualUser)userList.get(random);
            e.setUserId(userInfo.getId());
            e.setHeadImg(userInfo.getHeadImg());
            e.setUserNickname(userInfo.getNickname());
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)e, (Object)userReply);
            this.newsReplyMapper.updateReplyUserInfo(e);
            this.userReplyMapper.insertSelective(userReply);
        });
    }

    @Override
    public void delReply(Long id, Long newsId) {
        AdminNewsReply adminNewsReply = this.adminNewsReplyMapper.selectByPrimaryKey(id, newsId);
        if (adminNewsReply != null) {
            this.delMyReply(adminNewsReply.getId(), adminNewsReply.getUserId(), adminNewsReply.getNewsId(), (byte)0);
            this.messageService.sendMessageFilterForReply(null, id);
        }
    }
}

