/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.facade;

import com.bxm.localnews.news.domain.UserFollowMapper;
import com.bxm.localnews.news.domain.UserLocationSyncMapper;
import com.bxm.localnews.news.facade.UserSyncFacadeService;
import com.bxm.localnews.news.model.entity.UserFollowEntity;
import com.bxm.localnews.news.vo.UserLocationSyncVo;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.StringUtils;

@DubboService(protocol={"dubbo"}, version="1.0.0")
public class UserSyncFacadeServiceImpl
implements UserSyncFacadeService {
    private static final Logger log = LoggerFactory.getLogger(UserSyncFacadeServiceImpl.class);
    private UserFollowMapper userFollowMapper;
    private UserLocationSyncMapper userLocationSyncMapper;

    @Async
    public void changeLocation(Long userId, String areaCode) {
        Long uid = this.userLocationSyncMapper.hasUser(userId);
        UserLocationSyncVo userLocationSyncVo = new UserLocationSyncVo();
        userLocationSyncVo.setUserId(userId);
        userLocationSyncVo.setAreaCode(StringUtils.isEmpty((Object)areaCode) ? null : areaCode);
        if (null != uid) {
            this.userLocationSyncMapper.update(userLocationSyncVo);
        } else {
            this.userLocationSyncMapper.insert(userLocationSyncVo);
        }
    }

    @Async
    public void addFollow(Long userId, Long followUserId) {
        UserFollowEntity entity = new UserFollowEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setUserId(userId);
        entity.setFollowUserId(followUserId);
        this.userFollowMapper.insert((Object)entity);
    }

    @Async
    public void removeFollow(Long userId, Long unfollowUserId) {
        this.userFollowMapper.removeFollow(userId, unfollowUserId);
    }

    public UserSyncFacadeServiceImpl(UserFollowMapper userFollowMapper, UserLocationSyncMapper userLocationSyncMapper) {
        this.userFollowMapper = userFollowMapper;
        this.userLocationSyncMapper = userLocationSyncMapper;
    }
}

