/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.thread;

import com.bxm.localnews.integration.MessageService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.facade.service.ForumPostInnerService;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.vo.ForumReplyInfo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class PostReplyThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PostReplyThread.class);
    private final List<Long> postIds;
    private final CountDownLatch countDownLatch;
    private final RedisListAdapter redisListAdapter;
    private final UserIntegrationService userIntegrationService;
    private final MessageService messageService;
    private final ForumPostInnerService forumPostInnerService;
    private static final String COPY_WRITE_1 = "\u7b49%d\u4eba\u5728\u4f60\u8bc4\u8bba\u7684\u5185\u5bb9\u4e0b\u53d1\u8868\u4e86%d\u6761\u65b0\u8bc4\u8bba";
    private static final String COPY_WRITE_2 = "\u5728\u4f60\u8bc4\u8bba\u7684\u5185\u5bb9\u4e0b\u53d1\u8868\u4e86%d\u6761\u65b0\u8bc4\u8bba";

    public PostReplyThread(List<Long> postIds, CountDownLatch countDownLatch) {
        this.postIds = postIds;
        this.countDownLatch = countDownLatch;
        this.redisListAdapter = (RedisListAdapter)SpringContextHolder.getBean(RedisListAdapter.class);
        this.userIntegrationService = (UserIntegrationService)SpringContextHolder.getBean(UserIntegrationService.class);
        this.messageService = (MessageService)SpringContextHolder.getBean(MessageService.class);
        this.forumPostInnerService = (ForumPostInnerService)SpringContextHolder.getBean(ForumPostInnerService.class);
    }

    @Override
    public void run() {
        try {
            if (!CollectionUtils.isEmpty(this.postIds)) {
                log.info("postId:{}", this.postIds);
                this.postIds.forEach(e -> {
                    KeyGenerator replyInfoKey = RedisConfig.FORUM_REPLY_INFO.copy().appendKey(e);
                    try {
                        List replyInfo = this.redisListAdapter.leftIndex(replyInfoKey, -1L, (TypeReference)new TypeReference<ForumReplyInfo>(){});
                        this.dealDataAndSendPush(replyInfo, (Long)e);
                    }
                    finally {
                        this.redisListAdapter.remove(replyInfoKey);
                    }
                });
            }
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    private void dealDataAndSendPush(List<ForumReplyInfo> replyInfo, Long postId) {
        Set userIds = replyInfo.stream().map(ForumReplyInfo::getUserId).collect(Collectors.toSet());
        List userBeans = this.userIntegrationService.batchUserInfo((List)Lists.newArrayList(userIds));
        Map userInfos = userBeans.stream().collect(Collectors.toMap(UserBean::getId, Function.identity()));
        ForumPostVo forumPostVo = this.forumPostInnerService.getBriefInfo(postId);
        for (Long userId : userIds) {
            Optional<ForumReplyInfo> max;
            if (((UserBean)userInfos.get(userId)).getState() != 1 || !(max = replyInfo.stream().filter(e -> Objects.equal((Object)userId, (Object)e.getUserId())).max(Comparator.comparing(ForumReplyInfo::getReplyTime))).isPresent()) continue;
            Date maxTime = max.get().getReplyTime();
            List infos = replyInfo.stream().filter(e -> e.getReplyTime().compareTo(maxTime) > 0).sorted(Comparator.comparing(ForumReplyInfo::getReplyTime)).map(ForumReplyInfo::getUserId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(infos)) continue;
            int replyNum = infos.size();
            long userNum = infos.stream().distinct().count();
            if (userNum < 1L) continue;
            UserBean replyUser = (UserBean)userInfos.get(infos.get(0));
            String copyWrite = userNum > 1L ? String.format(COPY_WRITE_1, userNum, replyNum) : String.format(COPY_WRITE_2, replyNum);
            this.messageService.pushPostReply((UserBean)userInfos.get(userId), copyWrite, forumPostVo, replyUser);
        }
    }

    public List<Long> getPostIds() {
        return this.postIds;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public RedisListAdapter getRedisListAdapter() {
        return this.redisListAdapter;
    }

    public UserIntegrationService getUserIntegrationService() {
        return this.userIntegrationService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public ForumPostInnerService getForumPostInnerService() {
        return this.forumPostInnerService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostReplyThread)) {
            return false;
        }
        PostReplyThread other = (PostReplyThread)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Long> this$postIds = this.getPostIds();
        List<Long> other$postIds = other.getPostIds();
        if (this$postIds == null ? other$postIds != null : !((Object)this$postIds).equals(other$postIds)) {
            return false;
        }
        CountDownLatch this$countDownLatch = this.getCountDownLatch();
        CountDownLatch other$countDownLatch = other.getCountDownLatch();
        if (this$countDownLatch == null ? other$countDownLatch != null : !this$countDownLatch.equals(other$countDownLatch)) {
            return false;
        }
        RedisListAdapter this$redisListAdapter = this.getRedisListAdapter();
        RedisListAdapter other$redisListAdapter = other.getRedisListAdapter();
        if (this$redisListAdapter == null ? other$redisListAdapter != null : !this$redisListAdapter.equals(other$redisListAdapter)) {
            return false;
        }
        UserIntegrationService this$userIntegrationService = this.getUserIntegrationService();
        UserIntegrationService other$userIntegrationService = other.getUserIntegrationService();
        if (this$userIntegrationService == null ? other$userIntegrationService != null : !this$userIntegrationService.equals(other$userIntegrationService)) {
            return false;
        }
        MessageService this$messageService = this.getMessageService();
        MessageService other$messageService = other.getMessageService();
        if (this$messageService == null ? other$messageService != null : !this$messageService.equals(other$messageService)) {
            return false;
        }
        ForumPostInnerService this$forumPostInnerService = this.getForumPostInnerService();
        ForumPostInnerService other$forumPostInnerService = other.getForumPostInnerService();
        return !(this$forumPostInnerService == null ? other$forumPostInnerService != null : !this$forumPostInnerService.equals(other$forumPostInnerService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostReplyThread;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Long> $postIds = this.getPostIds();
        result = result * 59 + ($postIds == null ? 43 : ((Object)$postIds).hashCode());
        CountDownLatch $countDownLatch = this.getCountDownLatch();
        result = result * 59 + ($countDownLatch == null ? 43 : $countDownLatch.hashCode());
        RedisListAdapter $redisListAdapter = this.getRedisListAdapter();
        result = result * 59 + ($redisListAdapter == null ? 43 : $redisListAdapter.hashCode());
        UserIntegrationService $userIntegrationService = this.getUserIntegrationService();
        result = result * 59 + ($userIntegrationService == null ? 43 : $userIntegrationService.hashCode());
        MessageService $messageService = this.getMessageService();
        result = result * 59 + ($messageService == null ? 43 : $messageService.hashCode());
        ForumPostInnerService $forumPostInnerService = this.getForumPostInnerService();
        result = result * 59 + ($forumPostInnerService == null ? 43 : $forumPostInnerService.hashCode());
        return result;
    }

    public String toString() {
        return "PostReplyThread(postIds=" + this.getPostIds() + ", countDownLatch=" + this.getCountDownLatch() + ", redisListAdapter=" + this.getRedisListAdapter() + ", userIntegrationService=" + this.getUserIntegrationService() + ", messageService=" + this.getMessageService() + ", forumPostInnerService=" + this.getForumPostInnerService() + ")";
    }
}

