package com.bxm.localnews.news.facade;

import com.bxm.localnews.news.domain.UserFollowMapper;
import com.bxm.localnews.news.domain.UserLocationSyncMapper;
import com.bxm.localnews.news.model.entity.UserFollowEntity;
import com.bxm.localnews.news.vo.UserLocationSyncVo;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.StringUtils;

/**
 * 用户信息同步接口
 *
 * @author liujia
 * @date 9/29/21 4:38 PM
 **/
@DubboService(protocol = "dubbo", version = "1.0.0")
@Slf4j
@AllArgsConstructor
public class UserSyncFacadeServiceImpl implements UserSyncFacadeService {

    private UserFollowMapper userFollowMapper;

    private UserLocationSyncMapper userLocationSyncMapper;

    @Override
    @Async
    public void changeLocation(Long userId, String areaCode) {
        Long uid = userLocationSyncMapper.hasUser(userId);

        UserLocationSyncVo userLocationSyncVo = new UserLocationSyncVo();
        userLocationSyncVo.setUserId(userId);
        userLocationSyncVo.setAreaCode(StringUtils.isEmpty(areaCode) ? null : areaCode);

        if (null != uid) {
            userLocationSyncMapper.update(userLocationSyncVo);
        } else {
            userLocationSyncMapper.insert(userLocationSyncVo);
        }
    }

    @Override
    @Async
    public void addFollow(Long userId, Long followUserId) {
        UserFollowEntity entity = new UserFollowEntity();
        entity.setId(SequenceHolder.nextLongId());
        entity.setUserId(userId);
        entity.setFollowUserId(followUserId);

        userFollowMapper.insert(entity);
    }

    @Override
    @Async
    public void removeFollow(Long userId, Long unfollowUserId) {
        userFollowMapper.removeFollow(userId, unfollowUserId);
    }
}
