package com.bxm.localnews.news.service;

import com.bxm.localnews.news.model.vo.LocalCrumbs;

/**
 * 本地圈服务接口
 *
 * @author wzy
 * @version 1.0
 * @date 2020/9/22 1:58 下午
 */
public interface LocalCircleService {
    /**
     * 获取本地圈面包块信息（目前包含话题广场、同城交友）
     *
     * @param userId   用户id
     * @param areaCode 区域编码
     * @return 面包块信息
     */
    LocalCrumbs getLocalCrumbsInfo(String userId, String areaCode);

    /**
     * 上报面包块点击信息
     *
     * @param userId   用户id
     * @param areaCode 区域编码
     * @param type     面包块类型：1:话题广场，2：同城交友
     * @return
     */
    Boolean reportCrumbsInfo(Long userId, String areaCode, Integer type);
}