package com.bxm.localnews.news.service.impl;

import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.integration.MessageService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.comment.NewNewsReplyService;
import com.bxm.localnews.news.detail.helper.ForumPostImageHelper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.facade.service.ForumPostInnerService;
import com.bxm.localnews.news.image.ImageHelper;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.NewsReply;
import com.bxm.localnews.news.service.ReplyScheduleService;
import com.bxm.localnews.news.util.FormPostContentUtil;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

import static com.alibaba.fastjson.JSON.toJSONString;
import static java.util.stream.Collectors.groupingBy;

@Service
public class ReplyScheduleServiceImpl extends BaseService implements ReplyScheduleService {

    @Resource
    private NewsReplyMapper newsReplyMapper;

    @Resource
    private UserReplyMapper userReplyMapper;

    @Resource
    private MessageService messageService;

    @Resource
    private UserIntegrationService userIntegrationService;

    @Resource
    private ForumPostImageHelper forumPostImageHelper;

    @Resource
    private ImageHelper imageHelper;

    @Resource
    private ForumPostInnerService forumPostInnerService;

    @Override
    public void scanningNewsReply() {
        //查询已经到达显示时间、并且状态为未展示的的评论
        List<NewsReply> newsReplyList = newsReplyMapper.selectByTime();
        for (NewsReply newsReply : newsReplyList) {
            try {
                newsReplyMapper.updateStatus(newsReply.getNewsId(), newsReply.getId());
                userReplyMapper.updateStatus(newsReply.getUserId(), newsReply.getId());
                //维护静态数据及发送推送
                this.pushAndStatic(newsReply);
                logger.info("评论数据:[{}],推送时间:[{}]", toJSONString(newsReply), DateFormatUtils.format(new Date(), DateUtils.DATE_TIME_FORMAT));

                if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType()) {
                    NewNewsReplyService newNewsReplyService = SpringContextHolder.getBean(NewNewsReplyService.class);
                    newNewsReplyService.saveForumPostReplyRecord(newsReply.getUserId(), newsReply.getNewsId(), newsReply.getAddTime());
                }
            } catch (Exception e) {
                logger.error("帖子评论处理出错, newsReply: {}", toJSONString(newsReply), e);
            }
        }
        //分组查找需要维护静态数据的帖子,新闻
        Collection<List<NewsReply>> values = newsReplyList.stream().collect(groupingBy(NewsReply::getNewsId)).values();
        values.forEach(e -> {
            Optional<NewsReply> first = e.stream().findFirst();
            //维护静态静态数据
            first.ifPresent(newsReply -> SpringContextHolder.getBean(NewNewsReplyService.class).updateComment(newsReply));
        });
    }

    /**
     * 维护静态数据及发送推送
     *
     * @param newsReply
     */
    private void pushAndStatic(NewsReply newsReply) {
        //该评论为回复时,给上级评论人推送
        if (newsReply.getParentId() != 0 && newsReply.getRootId() != 0) {
            //维护根评论互动值
            NewsReply rootReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            // 评论可能出现null 至于为什么，我也不知道，好像是帖子被删除了之后，new_reply就是空的 但是总表有数据...
            if (Objects.isNull(rootReply)) {
                return;
            }

            Integer interactiveCount = rootReply.getInteractiveCount();
            interactiveCount = (Objects.isNull(interactiveCount) || interactiveCount == 0) ? 3 : interactiveCount + 3;
            rootReply.setInteractiveCount(interactiveCount);
            newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            //根评论状态为删除时,将该评论的状态也置为删除,同时不发送推送
            if (rootReply.getDeleteFlag() == 0) {
                //用户信息不为空,且上级评论的用户状态可用时放推送
                UserBean userBean = userIntegrationService.selectUserFromCache(newsReply.getParentUserId());
                boolean userAvailable = Objects.nonNull(userBean) && Objects.nonNull(userBean.getState()) && userBean.getState() == 1;
                if (userAvailable) {
                    if (newsReply.getType() == ReplyTypeEnum.POST_REPLY.getCode()) {
                        ForumPostVo forumPostVo = forumPostInnerService.getBriefInfo(newsReply.getNewsId());
                        if (null != forumPostVo && !forumPostVo.getStatus().equals(PostStatusEnum.USER_DELETE.getCode())) {
                            try {
                                FormPostContentUtil.replace(forumPostVo, null);
                                forumPostVo.setPostImgList(imageHelper.getDetailFromPost(forumPostVo.getPostImgList()));
                            } catch (Exception e) {
                                logger.error("[评论定时扫描]扫描评论表组装推送消息时报错:[{}],数据:[{}]", e.getMessage(), toJSONString(forumPostVo));
                            }
                            messageService.pushNewReplyMessage(newsReply, PushMessageEnum.POST_REPLY, forumPostVo);
                        }
                    }
                }
            } else {
                rootReply.setDeleteFlag((byte) 2);
                newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            }
        }
        //维护帖子,新闻静态数据,且发送推送
        if (newsReply.getType() == ReplyTypeEnum.POST_REPLY.getCode()) {
            if (newsReply.getRootId() == 0) {
                ForumPostVo forumPostVo = forumPostInnerService.getBriefInfo(newsReply.getNewsId());
                if (Objects.nonNull(forumPostVo) && !Objects.equals(forumPostVo.getStatus(), PostStatusEnum.USER_DELETE.getCode())) {
                    forumPostImageHelper.exchangeDetailPost(forumPostVo);
                    messageService.pushPostReplyMessage(newsReply, forumPostVo);
                }
            }
        }
    }

}



