package com.bxm.localnews.news.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.news.service.ReplyScheduleService;
import lombok.extern.slf4j.Slf4j;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 创建即发布的周期定时任务
 * 定时扫描 到底显示时间，但是显示状态为【未显示】的评论 将其设置为【显示】
 */
@Component
@Slf4j
public class NewsReplySyncTask implements ISimplifyElasticJob {

    @Resource
    private ReplyScheduleService replyScheduleService;

    @Override
    public String cron() {
        return "0/20 * * * * ? ";
    }

    @Override
    public String description() {
        return "扫描新闻评论表";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        log.info("扫描新闻评论表");
        replyScheduleService.scanningNewsReply();
    }
}
