package com.bxm.localnews.news.task;

import com.bxm.component.elasticjob.job.ISimplifyElasticJob;
import com.bxm.localnews.news.comment.NewNewsReplyService;
import lombok.extern.slf4j.Slf4j;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.springframework.stereotype.Component;

/**
 * 创建即发布的周期定时任务
 * 在指定时间，计算跟用户有关的评论，并且提醒用户回复
 */
@Component
@Slf4j
public class StatisticalPostReplyTask implements ISimplifyElasticJob {

    private final NewNewsReplyService newNewsReplyService;

    public StatisticalPostReplyTask(NewNewsReplyService newNewsReplyService) {
        this.newNewsReplyService = newNewsReplyService;
    }

    @Override
    public String cron() {
        return "0 0 9,12,18,21 * * ? ";
    }

    @Override
    public String description() {
        return "动态评论回复提醒";
    }

    @Override
    public void execute(ShardingContext shardingContext) {
        newNewsReplyService.statisticalPostReply();
    }
}
