/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.common.url;

import com.bxm.egg.common.url.AbstractProtocolBuilder;
import com.bxm.foundation.base.facade.enums.DomainScene;
import com.bxm.foundation.base.facade.enums.DomainViewScene;
import com.bxm.foundation.base.facade.param.DomainFetchParam;
import com.bxm.foundation.base.facade.service.DomainFacadeService;

public class HomeProtocolBuilder
extends AbstractProtocolBuilder {
    HomeProtocolBuilder(DomainFacadeService domainIntegrationService) {
        super(domainIntegrationService);
    }

    public OuterProtocolBuilder outer() {
        return new OuterProtocolBuilder();
    }

    public AppProtocolBuilder app() {
        return new AppProtocolBuilder();
    }

    public class AppProtocolBuilder {
        private Long userId;
        private Integer toast = 0;

        public AppProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public AppProtocolBuilder toast(Integer toast) {
            this.toast = toast;
            return this;
        }

        public String build() {
            return "egg://mine/userHomePage?userId=" + this.userId + "&toast=" + this.toast;
        }
    }

    public class OuterProtocolBuilder {
        private Long targetUserId;
        private Long userId;
        private String areaCode;
        private String areaName;

        public OuterProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public OuterProtocolBuilder targetUserId(Long targetUserId) {
            this.targetUserId = targetUserId;
            return this;
        }

        public OuterProtocolBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public OuterProtocolBuilder areaName(String areaName) {
            this.areaName = areaName;
            return this;
        }

        public String build() {
            String baseUrl = HomeProtocolBuilder.this.domainIntegrationService.getBaseUrlInfo(DomainFetchParam.builder().srcApp("egg").scene(DomainScene.OUTSIDE_SHARE).viewScene(DomainViewScene.CONTENT_VIEW).build());
            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("/shareUserHome.html?userId=").append(this.userId);
            if (null != this.targetUserId) {
                url.append("&targetUserId=").append(this.targetUserId);
            }
            if (null != this.areaCode) {
                url.append("&areaCode=").append(this.areaCode);
            }
            if (null != this.areaName) {
                url.append("&areaName=").append(HomeProtocolBuilder.this.encode(this.areaName));
            }
            return url.toString();
        }
    }
}

