/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.common.url;

import com.bxm.egg.common.url.AbstractProtocolBuilder;
import com.bxm.foundation.base.facade.enums.DomainScene;
import com.bxm.foundation.base.facade.enums.DomainViewScene;
import com.bxm.foundation.base.facade.param.DomainFetchParam;
import com.bxm.foundation.base.facade.service.DomainFacadeService;

public class TopicProtocolBuilder
extends AbstractProtocolBuilder {
    TopicProtocolBuilder(DomainFacadeService domainIntegrationService) {
        super(domainIntegrationService);
    }

    public OuterProtocolBuilder outer() {
        return new OuterProtocolBuilder();
    }

    public AppProtocolBuilder app() {
        return new AppProtocolBuilder();
    }

    public class AppProtocolBuilder {
        private Long topicId;

        public AppProtocolBuilder topicId(Long topicId) {
            this.topicId = topicId;
            return this;
        }

        public String build() {
            return "egg://community/topicDetail?tp=topic&topicId=" + this.topicId + "";
        }
    }

    public class OuterProtocolBuilder {
        private Long topicId;
        private Long userId;
        private String areaCode;
        private String areaName;

        public OuterProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public OuterProtocolBuilder topicId(Long topicId) {
            this.topicId = topicId;
            return this;
        }

        public OuterProtocolBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public OuterProtocolBuilder areaName(String areaName) {
            this.areaName = areaName;
            return this;
        }

        public String build() {
            String baseUrl = TopicProtocolBuilder.this.domainIntegrationService.getBaseUrlInfo(DomainFetchParam.builder().srcApp("egg").scene(DomainScene.OUTSIDE_SHARE).viewScene(DomainViewScene.CONTENT_VIEW).build());
            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("/shareTopicDetail.html");
            url.append("?id=").append(this.topicId);
            if (null != this.userId) {
                url.append("&userId=").append(this.userId);
            }
            if (null != this.areaCode) {
                url.append("&areaCode=").append(this.areaCode);
            }
            if (null != this.areaName) {
                url.append("&areaName=").append(TopicProtocolBuilder.this.encode(this.areaName));
            }
            return url.toString();
        }
    }
}

